/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.io.ByteSequence;
import org.openrewrite.config.PolyglotResourceLoader;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class NpmRegistryModuleLoader
extends PolyglotResourceLoader {
    private static final String JS = "js";
    private static final String JAVA = "java";

    public NpmRegistryModuleLoader(String registry, String ... modules) {
        if (!registry.endsWith("/")) {
            registry = registry + "/";
        }
        Context context = Context.newBuilder((String[])new String[]{JS, JAVA}).allowAllAccess(true).build();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (String module : modules) {
            try {
                if (!registry.startsWith("http")) {
                    Path path = Paths.get(registry, module, "package.json");
                    PackageDescriptor packageDescriptor = (PackageDescriptor)mapper.readValue(path.toFile(), PackageDescriptor.class);
                    String main = packageDescriptor.getMain();
                    Path jsPath = Paths.get(registry, module, main);
                    this.evalPolyglotRecipe(context, module + "@latest", Source.newBuilder((String)JS, (File)jsPath.toFile()).name(jsPath.toString()).build());
                    continue;
                }
                URI srcUri = URI.create(registry + module);
                PackagesDescriptor packages = (PackagesDescriptor)mapper.readValue(srcUri.toURL(), PackagesDescriptor.class);
                String latestVersion = packages.getDistTags().get("latest");
                PackageDescriptor packageDescriptor = packages.getVersions().get(latestVersion);
                String main = packageDescriptor.getMain();
                String tarball = (String)packageDescriptor.getDist().get("tarball");
                URI tarballUri = URI.create(tarball);
                try (TarArchiveInputStream tgzIn = new TarArchiveInputStream((InputStream)new GZIPInputStream(tarballUri.toURL().openStream()));){
                    TarArchiveEntry e;
                    while ((e = tgzIn.getNextTarEntry()) != null) {
                        String name = e.getName();
                        if (!name.endsWith(main) || !name.endsWith(JS) || !tgzIn.canReadEntryData((ArchiveEntry)e)) continue;
                        byte[] buff = new byte[Math.toIntExact(e.getSize())];
                        for (int i = 0; i < buff.length; i += tgzIn.read(buff, i, tgzIn.getRecordSize())) {
                        }
                        this.evalPolyglotRecipe(context, module + "@" + latestVersion, Source.newBuilder((String)JS, (ByteSequence)ByteSequence.create((byte[])buff), (String)name).build());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PackageDescriptor {
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="dist")
        Map<String, Object> dist;
        @JsonProperty(value="main")
        String main;

        public String getDescription() {
            return this.description;
        }

        public Map<String, Object> getDist() {
            return this.dist;
        }

        public String getMain() {
            return this.main;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="dist")
        public void setDist(Map<String, Object> dist) {
            this.dist = dist;
        }

        @JsonProperty(value="main")
        public void setMain(String main) {
            this.main = main;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackageDescriptor)) {
                return false;
            }
            PackageDescriptor other = (PackageDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Map<String, Object> this$dist = this.getDist();
            Map<String, Object> other$dist = other.getDist();
            if (this$dist == null ? other$dist != null : !((Object)this$dist).equals(other$dist)) {
                return false;
            }
            String this$main = this.getMain();
            String other$main = other.getMain();
            return !(this$main == null ? other$main != null : !this$main.equals(other$main));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof PackageDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Map<String, Object> $dist = this.getDist();
            result = result * 59 + ($dist == null ? 43 : ((Object)$dist).hashCode());
            String $main = this.getMain();
            result = result * 59 + ($main == null ? 43 : $main.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "NpmRegistryModuleLoader.PackageDescriptor(description=" + this.getDescription() + ", dist=" + this.getDist() + ", main=" + this.getMain() + ")";
        }
    }

    private static class PackagesDescriptor {
        @JsonProperty(value="dist-tags")
        Map<String, String> distTags;
        @JsonProperty(value="versions")
        Map<String, PackageDescriptor> versions;

        public Map<String, String> getDistTags() {
            return this.distTags;
        }

        public Map<String, PackageDescriptor> getVersions() {
            return this.versions;
        }

        @JsonProperty(value="dist-tags")
        public void setDistTags(Map<String, String> distTags) {
            this.distTags = distTags;
        }

        @JsonProperty(value="versions")
        public void setVersions(Map<String, PackageDescriptor> versions) {
            this.versions = versions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackagesDescriptor)) {
                return false;
            }
            PackagesDescriptor other = (PackagesDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$distTags = this.getDistTags();
            Map<String, String> other$distTags = other.getDistTags();
            if (this$distTags == null ? other$distTags != null : !((Object)this$distTags).equals(other$distTags)) {
                return false;
            }
            Map<String, PackageDescriptor> this$versions = this.getVersions();
            Map<String, PackageDescriptor> other$versions = other.getVersions();
            return !(this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof PackagesDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $distTags = this.getDistTags();
            result = result * 59 + ($distTags == null ? 43 : ((Object)$distTags).hashCode());
            Map<String, PackageDescriptor> $versions = this.getVersions();
            result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "NpmRegistryModuleLoader.PackagesDescriptor(distTags=" + this.getDistTags() + ", versions=" + this.getVersions() + ")";
        }
    }
}

