/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import org.openrewrite.SourceFile;

public class TreeSerializer<S extends SourceFile> {
    private final TypeReference<S> sourceType = new TypeReference<S>(){};
    private final TypeReference<List<S>> sourceListType = new TypeReference<List<S>>(){};
    private final ObjectMapper mapper;

    public TreeSerializer() {
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)f).constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new RelativePathModule()).registerModule((Module)new ParameterNamesModule()).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public void write(Iterable<S> sources, OutputStream out) {
        try {
            this.mapper.writeValue(out, sources);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] write(Iterable<S> sources) {
        try {
            return this.mapper.writeValueAsBytes(sources);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void write(S source, OutputStream out) {
        try {
            this.mapper.writeValue(out, source);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] write(S source) {
        try {
            return this.mapper.writeValueAsBytes(source);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public List<S> readList(InputStream input) {
        try {
            return (List)this.mapper.readValue(input, this.sourceListType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<S> readList(byte[] bytes) {
        try {
            return (List)this.mapper.readValue(bytes, this.sourceListType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public S read(InputStream input) {
        try {
            return (S)((SourceFile)this.mapper.readValue(input, this.sourceType));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public S read(byte[] bytes) {
        try {
            return (S)((SourceFile)this.mapper.readValue(bytes, this.sourceType));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class RelativePathModule
    extends SimpleModule {
        public RelativePathModule() {
            this.addSerializer((JsonSerializer)new RelativePathSerializer());
        }

        private static class RelativePathSerializer
        extends StdSerializer<Path> {
            protected RelativePathSerializer() {
                super(Path.class);
            }

            public void serialize(Path value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value.toString());
            }
        }
    }
}

