/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.lang.NullUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.scheduling.ForkJoinScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public abstract class Recipe {
    public static final String PANIC = "__AHHH_PANIC!!!__";
    private static final Logger logger = LoggerFactory.getLogger(Recipe.class);
    static final TreePrinter<ExecutionContext> MARKER_ID_PRINTER = new TreePrinter<ExecutionContext>(){

        @Override
        public void doBefore(@Nullable Tree tree, StringBuilder printerAcc, ExecutionContext executionContext) {
            String markerIds;
            if (tree instanceof Markers && !(markerIds = ((Markers)tree).entries().stream().filter(marker -> !(marker instanceof RecipeThatMadeChanges)).map(marker -> String.valueOf(marker.hashCode())).collect(Collectors.joining(","))).isEmpty()) {
                printerAcc.append("markers[").append(markerIds).append("]->");
            }
        }
    };
    public static final TreeVisitor<?, ExecutionContext> NOOP = new TreeVisitor<Tree, ExecutionContext>(){

        @Override
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            return tree;
        }
    };
    @JsonIgnore
    private final List<Recipe> recipeList = new ArrayList<Recipe>();

    @JsonProperty(value="@c")
    public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    public abstract String getDisplayName();

    public String getDescription() {
        return "";
    }

    public Set<String> getTags() {
        return Collections.emptySet();
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return null;
    }

    public final RecipeDescriptor getDescriptor() {
        return RecipeIntrospectionUtils.recipeDescriptorFromRecipe(this);
    }

    public List<String> getLanguages() {
        return Collections.emptyList();
    }

    @Incubating(since="7.3.0")
    public boolean causesAnotherCycle() {
        return false;
    }

    public Recipe doNext(Recipe recipe) {
        this.recipeList.add(recipe);
        return this;
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return NOOP;
    }

    @Nullable
    @Incubating(since="7.2.0")
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return null;
    }

    @Nullable
    @Incubating(since="7.4.0")
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return null;
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return before;
    }

    public final List<Result> run(List<? extends SourceFile> before) {
        return this.run(before, new InMemoryExecutionContext());
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx) {
        return this.run(before, ctx, 3);
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles) {
        return this.run(before, ctx, ForkJoinScheduler.common(), maxCycles, 1);
    }

    @Incubating(since="7.3.0")
    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx, RecipeScheduler recipeScheduler, int maxCycles, int minCycles) {
        return recipeScheduler.scheduleRun(this, before, ctx, maxCycles, minCycles);
    }

    @Incubating(since="7.0.0")
    public Validated validate(ExecutionContext ctx) {
        return this.validate();
    }

    public Validated validate() {
        Validated validated = Validated.none();
        List<Field> requiredFields = NullUtils.findNonNullFields(this.getClass());
        for (Field field : requiredFields) {
            try {
                validated = validated.and(Validated.required(field.getName(), field.get(this)));
            }
            catch (IllegalAccessException e) {
                logger.warn("Unable to validate the field [{}] on the class [{}]", (Object)field.getName(), (Object)this.getClass().getName());
            }
        }
        return validated;
    }

    @Incubating(since="7.0.0")
    public final Collection<Validated> validateAll(ExecutionContext ctx) {
        return this.validateAll(ctx, new ArrayList<Validated>());
    }

    public final Collection<Validated> validateAll() {
        return this.validateAll(new InMemoryExecutionContext(), new ArrayList<Validated>());
    }

    private Collection<Validated> validateAll(ExecutionContext ctx, Collection<Validated> acc) {
        acc.add(this.validate(ctx));
        for (Recipe recipe : this.recipeList) {
            recipe.validateAll(ctx, acc);
        }
        return acc;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.getName().equals(recipe.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    static class RecipeThatMadeChanges
    implements Marker {
        private final Set<Recipe> recipes = new LinkedHashSet<Recipe>();
        private final UUID id;

        RecipeThatMadeChanges(Recipe recipe) {
            this.recipes.add(recipe);
            this.id = Tree.randomId();
        }

        public Set<Recipe> getRecipes() {
            return this.recipes;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecipeThatMadeChanges)) {
                return false;
            }
            RecipeThatMadeChanges other = (RecipeThatMadeChanges)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof RecipeThatMadeChanges;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }
    }
}

