/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeException;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeNamedStyles;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.yaml.snakeyaml.Yaml;

public class YamlResourceLoader
implements ResourceLoader {
    int refCount = 0;
    private static final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}", ":");
    private final URI source;
    private final String yamlSource;
    private final ObjectMapper mapper;

    public YamlResourceLoader(InputStream yamlInput, URI source, Properties properties) throws UncheckedIOException {
        this(yamlInput, source, properties, null);
    }

    public YamlResourceLoader(InputStream yamlInput, URI source, Properties properties, @Nullable ClassLoader classLoader) throws UncheckedIOException {
        this.source = source;
        this.mapper = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new KotlinModule()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        if (classLoader != null) {
            TypeFactory tf = TypeFactory.defaultInstance().withClassLoader(classLoader);
            this.mapper.setTypeFactory(tf);
        }
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = yamlInput.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            this.yamlSource = propertyPlaceholderHelper.replacePlaceholders(new String(buffer.toByteArray(), StandardCharsets.UTF_8), properties);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Collection<Map<String, Object>> loadResources(ResourceType resourceType) {
        ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
        Yaml yaml = new Yaml();
        for (Object resource : yaml.loadAll(this.yamlSource)) {
            Map resourceMap;
            if (!(resource instanceof Map) || !resourceType.equals((Object)ResourceType.fromSpec((String)(resourceMap = (Map)resource).get("type")))) continue;
            resources.add(resourceMap);
        }
        return resources;
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.loadResources(ResourceType.Recipe).stream().filter(r -> r.containsKey("name")).map(r -> {
            String name = (String)r.get("name");
            String displayName = (String)r.get("displayName");
            if (displayName == null) {
                displayName = name;
            }
            String description = (String)r.get("description");
            Set<String> tags = Collections.emptySet();
            List rawTags = (List)r.get("tags");
            if (rawTags != null) {
                tags = new HashSet(rawTags);
            }
            DeclarativeRecipe recipe = new DeclarativeRecipe(name, displayName, description, tags, this.source);
            List recipeList = (List)r.get("recipeList");
            if (recipeList == null) {
                throw new RecipeException("Invalid Recipe [" + name + "] recipeList is null");
            }
            for (int i = 0; i < recipeList.size(); ++i) {
                Object next = recipeList.get(i);
                if (next instanceof String) {
                    recipe.doNext((String)next);
                    continue;
                }
                if (next instanceof Map) {
                    Map.Entry nameAndConfig = ((Map)next).entrySet().iterator().next();
                    try {
                        if (nameAndConfig.getValue() instanceof Map) {
                            HashMap withJsonType = new HashMap((Map)nameAndConfig.getValue());
                            withJsonType.put("@c", nameAndConfig.getKey());
                            try {
                                recipe.doNext((Recipe)this.mapper.convertValue(withJsonType, Recipe.class));
                            }
                            catch (IllegalArgumentException e) {
                                if (!(e.getCause() instanceof InvalidTypeIdException)) continue;
                                recipe.addValidation(Validated.invalid((String)nameAndConfig.getKey(), nameAndConfig.getValue(), "Recipe class " + (String)nameAndConfig.getKey() + " cannot be found"));
                            }
                            continue;
                        }
                        recipe.addValidation(Validated.invalid((String)nameAndConfig.getKey(), nameAndConfig.getValue(), "Declarative recipeList entries are expected to be strings or mappings"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        recipe.addValidation(Validated.invalid((String)nameAndConfig.getKey(), nameAndConfig.getValue(), "Unexpected declarative recipe parsing exception " + e.getClass().getName()));
                    }
                    continue;
                }
                recipe.addValidation(Validated.invalid(name + ".recipeList[" + i + "] (in " + this.source + ")", next, "is an object type that isn't recognized as a recipe.", null));
            }
            return recipe;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.listRecipeDescriptors(Collections.emptyList());
    }

    public Collection<RecipeDescriptor> listRecipeDescriptors(Collection<Recipe> externalRecipes) {
        Collection<Recipe> internalRecipes = this.listRecipes();
        Collection allRecipes = Stream.concat(externalRecipes.stream(), internalRecipes.stream()).collect(Collectors.toList());
        ArrayList<RecipeDescriptor> recipeDescriptors = new ArrayList<RecipeDescriptor>();
        for (Recipe recipe : internalRecipes) {
            DeclarativeRecipe declarativeRecipe = (DeclarativeRecipe)recipe;
            declarativeRecipe.initialize(allRecipes);
            recipeDescriptors.add(RecipeIntrospectionUtils.recipeDescriptorFromDeclarativeRecipe(declarativeRecipe, this.source));
        }
        return recipeDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.loadResources(ResourceType.Style).stream().filter(r -> r.containsKey("name")).map(s -> {
            ArrayList<Style> styles = new ArrayList<Style>();
            String name = (String)s.get("name");
            String displayName = (String)s.get("displayName");
            if (displayName == null) {
                displayName = name;
            }
            String description = (String)s.get("description");
            Set<String> tags = Collections.emptySet();
            List rawTags = (List)s.get("tags");
            if (rawTags != null) {
                tags = new HashSet(rawTags);
            }
            DeclarativeNamedStyles namedStyles = new DeclarativeNamedStyles(Tree.randomId(), name, displayName, description, tags, styles);
            List styleConfigs = (List)s.get("styleConfigs");
            if (styleConfigs != null) {
                for (int i = 0; i < styleConfigs.size(); ++i) {
                    Object next = styleConfigs.get(i);
                    if (next instanceof String) {
                        String styleClassName = (String)next;
                        try {
                            styles.add((Style)Class.forName(styleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (Exception e) {
                            namedStyles.addValidation(Validated.invalid(name + ".styleConfigs[" + i + "] (in " + this.source + ")", next, "is a style that cannot be constructed.", e));
                        }
                        continue;
                    }
                    if (next instanceof Map) {
                        Map.Entry nameAndConfig = ((Map)next).entrySet().iterator().next();
                        try {
                            HashMap<String, Object> withJsonType = new HashMap<String, Object>((Map)nameAndConfig.getValue());
                            withJsonType.put("@c", nameAndConfig.getKey());
                            withJsonType.put("@ref", this.refCount++);
                            Style e = (Style)this.mapper.convertValue(withJsonType, Style.class);
                            styles.add(e);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    namedStyles.addValidation(Validated.invalid(name + ".styleConfigs[" + i + "] (in " + this.source + ")", next, "is an object type that isn't recognized as a style.", null));
                }
            }
            return namedStyles;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.loadResources(ResourceType.Category).stream().filter(r -> r.containsKey("name") && r.containsKey("packageName")).map(c -> {
            String name = (String)c.get("name");
            String packageName = (String)c.get("packageName");
            String description = (String)c.get("description");
            Set<String> tags = Collections.emptySet();
            List rawTags = (List)c.get("tags");
            if (rawTags != null) {
                tags = new HashSet(rawTags);
            }
            return new CategoryDescriptor(name, packageName, description, tags);
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<RecipeExample> listRecipeExamples() {
        return this.loadResources(ResourceType.Example).stream().map(c -> new RecipeExample((String)c.get("name"), (String)c.get("description"), (String)c.get("recipe"), (String)c.get("before"), (String)c.get("after"))).collect(Collectors.toList());
    }

    private static enum ResourceType {
        Recipe("specs.openrewrite.org/v1beta/recipe"),
        Style("specs.openrewrite.org/v1beta/style"),
        Category("specs.openrewrite.org/v1beta/category"),
        Example("specs.openrewrite.org/v1beta/example");

        private final String spec;

        private ResourceType(String spec) {
            this.spec = spec;
        }

        public String getSpec() {
            return this.spec;
        }

        @Nullable
        public static ResourceType fromSpec(@Nullable String spec) {
            return Arrays.stream(ResourceType.values()).filter(type -> type.getSpec().equals(spec)).findAny().orElse(null);
        }
    }
}

