/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import org.openrewrite.Cursor;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class PlainTextPrinter<P>
extends PlainTextVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public PlainTextPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    public String print(PlainText text, P p) {
        this.setCursor(new Cursor(null, "EPSILON"));
        this.visit(text, p);
        return this.getPrinter().toString();
    }

    @Override
    public PlainText visitText(PlainText text, P p) {
        this.visitMarkers(text.getMarkers(), p);
        this.getPrinter().append(text.getText());
        return text;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getNearestMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, acc);
        }
        return acc;
    }

    @Override
    public <M extends Marker> M visitMarker(Marker marker, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore(marker, acc, p);
        acc.append(marker.print(this.treePrinter, p));
        this.treePrinter.doAfter(marker, acc, p);
        return (M)marker;
    }

    @Override
    public Markers visitMarkers(Markers markers, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore(markers, acc, p);
        Markers m = super.visitMarkers(markers, p);
        this.treePrinter.doAfter(markers, acc, p);
        return m;
    }
}

