/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.marker.Marker;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@Incubating(since="7.0.0")
public class Markers {
    public static final Markers EMPTY = new Markers((Collection)Collections.emptyList()){

        public String toString() {
            return "Markers{EMPTY}";
        }
    };
    private final Collection<? extends Marker> markers;

    private Markers(Collection<? extends Marker> markers) {
        this.markers = markers;
    }

    @JsonCreator
    public static Markers build(Collection<? extends Marker> markers) {
        return markers.isEmpty() ? EMPTY : new Markers(markers);
    }

    public Collection<? extends Marker> entries() {
        return this.markers;
    }

    public Markers add(Marker marker) {
        if (this.markers.stream().anyMatch(marker::equals)) {
            return this;
        }
        ArrayList<? extends Marker> updatedmarker = new ArrayList<Marker>(this.markers);
        updatedmarker.add(marker);
        return new Markers(updatedmarker);
    }

    public <M extends Marker> Markers compute(M identity, BinaryOperator<M> remappingFunction) {
        ArrayList<Marker> updatedmarker = new ArrayList<Marker>(this.markers.size() + 1);
        boolean updated = false;
        for (Marker marker : this.markers) {
            if (marker.equals(identity)) {
                updatedmarker.add((Marker)remappingFunction.apply(marker, identity));
                updated = true;
                continue;
            }
            updatedmarker.add(marker);
        }
        if (!updated) {
            updatedmarker.add(identity);
        }
        return new Markers(updatedmarker);
    }

    public <M extends Marker> List<M> findAll(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).collect(Collectors.toList());
    }

    public <M extends Marker> Optional<M> findFirst(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).findFirst();
    }
}

