/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.ketch;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.openrewrite.shaded.jgit.annotations.Nullable;
import org.openrewrite.shaded.jgit.internal.ketch.KetchConstants;
import org.openrewrite.shaded.jgit.internal.ketch.KetchLeader;
import org.openrewrite.shaded.jgit.internal.ketch.KetchText;
import org.openrewrite.shaded.jgit.internal.ketch.LogIndex;
import org.openrewrite.shaded.jgit.internal.ketch.Proposal;
import org.openrewrite.shaded.jgit.internal.ketch.Round;
import org.openrewrite.shaded.jgit.internal.ketch.StageBuilder;
import org.openrewrite.shaded.jgit.internal.ketch.TimeIsUncertainException;
import org.openrewrite.shaded.jgit.internal.storage.reftree.Command;
import org.openrewrite.shaded.jgit.internal.storage.reftree.RefTree;
import org.openrewrite.shaded.jgit.lib.CommitBuilder;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectInserter;
import org.openrewrite.shaded.jgit.lib.PersonIdent;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;
import org.openrewrite.shaded.jgit.transport.ReceiveCommand;
import org.openrewrite.shaded.jgit.util.time.ProposedTimestamp;

class ProposalRound
extends Round {
    private final List<Proposal> todo;
    private RefTree queuedTree;

    ProposalRound(KetchLeader leader, LogIndex head, List<Proposal> todo, @Nullable RefTree tree) {
        super(leader, head);
        this.todo = todo;
        if (tree != null && ProposalRound.canCombine(todo)) {
            this.queuedTree = tree;
        } else {
            leader.roundHoldsReferenceToRefTree = false;
        }
    }

    private static boolean canCombine(List<Proposal> todo) {
        Proposal first = todo.get(0);
        int i = 1;
        while (i < todo.size()) {
            if (!ProposalRound.canCombine(first, todo.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canCombine(Proposal a, Proposal b) {
        String bMsg;
        String aMsg = ProposalRound.nullToEmpty(a.getMessage());
        return aMsg.equals(bMsg = ProposalRound.nullToEmpty(b.getMessage())) && ProposalRound.canCombine(a.getAuthor(), b.getAuthor());
    }

    private static String nullToEmpty(@Nullable String str) {
        return str != null ? str : "";
    }

    private static boolean canCombine(@Nullable PersonIdent a, @Nullable PersonIdent b) {
        if (a != null && b != null) {
            return a.getName().equals(b.getName()) && a.getEmailAddress().equals(b.getEmailAddress());
        }
        return a == null && b == null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    void start() throws IOException {
        for (Proposal p : this.todo) {
            p.notifyState(Proposal.State.RUNNING);
        }
        try {
            var2_1 = null;
            var3_7 = null;
            try {
                git = this.leader.openRepository();
                try {
                    ts = this.getSystem().getClock().propose();
                    try {
                        id = this.insertProposals(git, ts);
                        this.blockUntil(ts);
                    }
                    finally {
                        if (ts != null) {
                            ts.close();
                        }
                    }
                    if (git != null) {
                        git.close();
                    }
                }
                catch (Throwable var3_8) {
                    if (var2_1 == null) {
                        var2_1 = var3_8;
                    } else if (var2_1 != var3_8) {
                        var2_1.addSuppressed(var3_8);
                    }
                    if (git != null) {
                        git.close();
                    }
                    throw var2_1;
                }
            }
            catch (Throwable var3_9) {
                if (var2_1 == null) {
                    var2_1 = var3_9;
                } else if (var2_1 != var3_9) {
                    var2_1.addSuppressed(var3_9);
                }
                throw var2_1;
            }
            this.runAsync(id);
        }
        catch (NoOp e) {
            ** for (p : this.todo)
        }
lbl-1000:
        // 1 sources

        {
            p.success();
            continue;
        }
lbl46:
        // 1 sources

        this.leader.lock.lock();
        try {
            this.leader.nextRound();
        }
        finally {
            this.leader.lock.unlock();
        }
        catch (IOException e) {
            this.abort();
            throw e;
        }
    }

    private ObjectId insertProposals(Repository git, ProposedTimestamp ts) throws IOException, NoOp {
        ObjectId id;
        Throwable throwable = null;
        Object var5_5 = null;
        try (ObjectInserter inserter = git.newObjectInserter();){
            id = this.queuedTree != null ? this.insertSingleProposal(git, ts, inserter) : this.insertMultiProposal(git, ts, inserter);
            this.stageCommands = this.makeStageList(git, inserter);
            inserter.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return id;
    }

    private ObjectId insertSingleProposal(Repository git, ProposedTimestamp ts, ObjectInserter inserter) throws IOException, NoOp {
        ObjectId treeId = this.queuedTree.writeTree(inserter);
        this.queuedTree = null;
        this.leader.roundHoldsReferenceToRefTree = false;
        if (!ObjectId.zeroId().equals(this.acceptedOldIndex)) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (RevWalk rw = new RevWalk(git);){
                RevCommit c = rw.parseCommit(this.acceptedOldIndex);
                if (treeId.equals(c.getTree())) {
                    throw new NoOp();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Proposal p = this.todo.get(0);
        CommitBuilder b = new CommitBuilder();
        b.setTreeId(treeId);
        if (!ObjectId.zeroId().equals(this.acceptedOldIndex)) {
            b.setParentId(this.acceptedOldIndex);
        }
        b.setCommitter(this.leader.getSystem().newCommitter(ts));
        b.setAuthor(p.getAuthor() != null ? p.getAuthor() : b.getCommitter());
        b.setMessage(this.message(p));
        return inserter.insert(b);
    }

    private ObjectId insertMultiProposal(Repository git, ProposedTimestamp ts, ObjectInserter inserter) throws IOException, NoOp {
        RefTree tree;
        ObjectId oldTreeId;
        ObjectId lastIndex = this.acceptedOldIndex;
        if (ObjectId.zeroId().equals(lastIndex)) {
            oldTreeId = ObjectId.zeroId();
            tree = RefTree.newEmptyTree();
        } else {
            Throwable throwable = null;
            Object var8_9 = null;
            try (RevWalk rw = new RevWalk(git);){
                RevCommit c = rw.parseCommit(lastIndex);
                oldTreeId = c.getTree();
                tree = RefTree.read(rw.getObjectReader(), c.getTree());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        PersonIdent committer = this.leader.getSystem().newCommitter(ts);
        for (Proposal p : this.todo) {
            if (!tree.apply(p.getCommands())) {
                throw new IOException(KetchText.get().queuedProposalFailedToApply);
            }
            ObjectId treeId = tree.writeTree(inserter);
            if (treeId.equals(oldTreeId)) continue;
            CommitBuilder b = new CommitBuilder();
            b.setTreeId(treeId);
            if (!ObjectId.zeroId().equals(lastIndex)) {
                b.setParentId(lastIndex);
            }
            b.setAuthor(p.getAuthor() != null ? p.getAuthor() : committer);
            b.setCommitter(committer);
            b.setMessage(this.message(p));
            lastIndex = inserter.insert(b);
        }
        if (lastIndex.equals(this.acceptedOldIndex)) {
            throw new NoOp();
        }
        return lastIndex;
    }

    private String message(Proposal p) {
        StringBuilder m = new StringBuilder();
        String msg = p.getMessage();
        if (msg != null && !msg.isEmpty()) {
            m.append(msg);
            while (m.length() < 2 || m.charAt(m.length() - 2) != '\n' || m.charAt(m.length() - 1) != '\n') {
                m.append('\n');
            }
        }
        m.append(KetchConstants.TERM.getName()).append(": ").append(this.leader.getTerm());
        return m.toString();
    }

    void abort() {
        for (Proposal p : this.todo) {
            p.abort();
        }
    }

    @Override
    void success() {
        for (Proposal p : this.todo) {
            p.success();
        }
    }

    private List<ReceiveCommand> makeStageList(Repository git, ObjectInserter inserter) throws IOException {
        HashMap<String, ObjectId> byRef = new HashMap<String, ObjectId>();
        for (Proposal p : this.todo) {
            for (Command c : p.getCommands()) {
                Ref n = c.getNewRef();
                if (n == null || n.isSymbolic()) continue;
                byRef.put(n.getName(), n.getObjectId());
            }
        }
        if (byRef.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ObjectId> newObjs = new HashSet<ObjectId>(byRef.values());
        StageBuilder b = new StageBuilder(this.leader.getSystem().getTxnStage(), this.acceptedNewIndex);
        return b.makeStageList(newObjs, git, inserter);
    }

    private void blockUntil(ProposedTimestamp ts) throws TimeIsUncertainException {
        List times = this.todo.stream().flatMap(p -> p.getProposedTimestamps().stream()).collect(Collectors.toCollection(ArrayList::new));
        times.add(ts);
        try {
            Duration maxWait = this.getSystem().getMaxWaitForMonotonicClock();
            ProposedTimestamp.blockUntil(times, maxWait);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new TimeIsUncertainException(e);
        }
    }

    private static class NoOp
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoOp() {
        }
    }
}

