/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.StreamSupport;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.style.NamedStyles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningLoader
implements ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanningLoader.class);
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
    private final List<RecipeDescriptor> recipeDescriptors = new ArrayList<RecipeDescriptor>();

    public ClasspathScanningLoader(Iterable<Path> compileClasspath, Properties properties, String[] acceptPackages) {
        this.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties);
        this.scanClasses(new ClassGraph(), acceptPackages);
        if (compileClasspath.iterator().hasNext()) {
            URLClassLoader classpathLoader = new URLClassLoader((URL[])StreamSupport.stream(compileClasspath.spliterator(), false).map(cc -> {
                try {
                    return cc.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
            }).toArray(URL[]::new), this.getClass().getClassLoader());
            this.scanYaml(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classpathLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties);
            this.scanClasses(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classpathLoader}), acceptPackages);
        }
    }

    private void scanYaml(ClassGraph classGraph, Properties properties) {
        try (ScanResult scanResult = classGraph.enableMemoryMapping().scan();){
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> {
                YamlResourceLoader resourceLoader = new YamlResourceLoader(input, res.getURI(), properties);
                this.recipes.addAll(resourceLoader.listRecipes());
                this.recipeDescriptors.addAll(resourceLoader.listRecipeDescriptors());
                this.styles.addAll(resourceLoader.listStyles());
            });
        }
    }

    private void scanClasses(ClassGraph classGraph, String[] acceptPackages) {
        try (ScanResult result = classGraph.ignoreClassVisibility().acceptPackages(acceptPackages).scan();){
            for (ClassInfo classInfo : result.getSubclasses(Recipe.class.getName())) {
                Class recipeClass = classInfo.loadClass();
                try {
                    ArrayList<String> parameters = new ArrayList<String>();
                    Constructor<?>[] constructorArray = recipeClass.getConstructors();
                    int n = constructorArray.length;
                    for (int i = 0; i < n; ++i) {
                        Constructor<?> constructor = constructorArray[i];
                        for (int i2 = 0; i2 < constructor.getParameters().length; ++i2) {
                            Parameter param = constructor.getParameters()[i2];
                            parameters.add(param.getName());
                        }
                        if (constructor.getParameterCount() != 0) continue;
                        constructor.setAccessible(true);
                        this.recipes.add((Recipe)constructor.newInstance(new Object[0]));
                        break;
                    }
                    this.recipeDescriptors.add(new RecipeDescriptor(classInfo.getName(), parameters));
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)recipeClass.getName(), (Object)e);
                }
            }
            block12: for (ClassInfo classInfo : result.getSubclasses(NamedStyles.class.getName())) {
                Class styleClass = classInfo.loadClass();
                try {
                    for (Constructor<?> constructor : styleClass.getConstructors()) {
                        if (constructor.getParameterCount() != 0) continue;
                        constructor.setAccessible(true);
                        this.styles.add((NamedStyles)constructor.newInstance(new Object[0]));
                        continue block12;
                    }
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)styleClass.getName(), (Object)e);
                }
            }
        }
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.recipeDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.styles;
    }
}

