/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.ketch;

import java.io.IOException;
import java.util.List;
import org.openrewrite.shaded.jgit.internal.ketch.KetchLeader;
import org.openrewrite.shaded.jgit.internal.ketch.KetchSystem;
import org.openrewrite.shaded.jgit.internal.ketch.LogIndex;
import org.openrewrite.shaded.jgit.lib.AnyObjectId;
import org.openrewrite.shaded.jgit.transport.ReceiveCommand;

abstract class Round {
    final KetchLeader leader;
    final LogIndex acceptedOldIndex;
    LogIndex acceptedNewIndex;
    List<ReceiveCommand> stageCommands;

    Round(KetchLeader leader, LogIndex head) {
        this.leader = leader;
        this.acceptedOldIndex = head;
    }

    KetchSystem getSystem() {
        return this.leader.getSystem();
    }

    abstract void start() throws IOException;

    void runAsync(AnyObjectId newId) {
        this.acceptedNewIndex = this.acceptedOldIndex.nextIndex(newId);
        this.leader.runAsync(this);
    }

    abstract void success();
}

