/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.ketch;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrewrite.shaded.jgit.internal.ketch.KetchLeader;
import org.openrewrite.shaded.jgit.internal.ketch.KetchReplica;
import org.openrewrite.shaded.jgit.internal.ketch.KetchText;
import org.openrewrite.shaded.jgit.internal.ketch.ReplicaConfig;
import org.openrewrite.shaded.jgit.internal.ketch.ReplicaFetchRequest;
import org.openrewrite.shaded.jgit.internal.ketch.ReplicaPushRequest;
import org.openrewrite.shaded.jgit.internal.storage.reftree.RefTreeDatabase;
import org.openrewrite.shaded.jgit.lib.BatchRefUpdate;
import org.openrewrite.shaded.jgit.lib.NullProgressMonitor;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.RefDatabase;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;
import org.openrewrite.shaded.jgit.transport.ReceiveCommand;
import org.openrewrite.shaded.jgit.util.time.MonotonicClock;
import org.openrewrite.shaded.jgit.util.time.ProposedTimestamp;

public class LocalReplica
extends KetchReplica {
    public LocalReplica(KetchLeader leader, String name, ReplicaConfig cfg) {
        super(leader, name, cfg);
    }

    @Override
    protected String describeForLog() {
        return String.format("%s (leader)", this.getName());
    }

    void initialize(Repository repo) throws IOException {
        RefDatabase refdb = repo.getRefDatabase();
        if (refdb instanceof RefTreeDatabase) {
            RefTreeDatabase treeDb = (RefTreeDatabase)refdb;
            String txnNamespace = this.getSystem().getTxnNamespace();
            if (!txnNamespace.equals(treeDb.getTxnNamespace())) {
                throw new IOException(MessageFormat.format(KetchText.get().mismatchedTxnNamespace, txnNamespace, treeDb.getTxnNamespace()));
            }
            refdb = treeDb.getBootstrap();
        }
        this.initialize(refdb.exactRef(this.getSystem().getTxnAccepted(), this.getSystem().getTxnCommitted()));
    }

    @Override
    protected void startPush(ReplicaPushRequest req) {
        this.getSystem().getExecutor().execute(() -> {
            MonotonicClock clk = this.getSystem().getClock();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    Repository git = this.getLeader().openRepository();
                    try {
                        try (ProposedTimestamp ts = clk.propose();){
                            try {
                                this.update(git, req, ts);
                                req.done(git);
                            }
                            catch (Throwable err) {
                                req.setException(git, err);
                            }
                        }
                        if (git != null) {
                            git.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (git != null) {
                            git.close();
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException err) {
                req.setException(null, err);
            }
        });
    }

    @Override
    protected void blockingFetch(Repository repo, ReplicaFetchRequest req) throws IOException {
        throw new IOException(KetchText.get().cannotFetchFromLocalReplica);
    }

    private void update(Repository git, ReplicaPushRequest req, ProposedTimestamp ts) throws IOException {
        Object refs;
        RefDatabase refdb = git.getRefDatabase();
        KetchReplica.CommitMethod method = this.getCommitMethod();
        if (refdb instanceof RefTreeDatabase) {
            if (!this.isOnlyTxnNamespace(req.getCommands())) {
                return;
            }
            refdb = ((RefTreeDatabase)refdb).getBootstrap();
            method = KetchReplica.CommitMethod.TXN_COMMITTED;
        }
        BatchRefUpdate batch = refdb.newBatchUpdate();
        batch.addProposedTimestamp(ts);
        batch.setRefLogIdent(this.getSystem().newCommitter(ts));
        batch.setRefLogMessage("ketch", false);
        batch.setAllowNonFastForwards(true);
        ReceiveCommand accepted = null;
        ReceiveCommand committed = null;
        for (ReceiveCommand cmd : req.getCommands()) {
            String name = cmd.getRefName();
            if (name.equals(this.getSystem().getTxnAccepted())) {
                accepted = cmd;
                continue;
            }
            if (name.equals(this.getSystem().getTxnCommitted())) {
                committed = cmd;
                continue;
            }
            batch.addCommand(cmd);
        }
        if (committed != null && method == KetchReplica.CommitMethod.ALL_REFS) {
            refs = refdb.getRefs("");
            batch.addCommand(this.prepareCommit(git, (Map<String, Ref>)refs, committed.getNewId()));
        }
        if (accepted != null) {
            batch.addCommand(accepted);
        }
        if (committed != null) {
            batch.addCommand(committed);
        }
        refs = null;
        Iterator<ReceiveCommand> iterator = null;
        try (RevWalk rw = new RevWalk(git);){
            batch.execute(rw, NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable) {
            if (refs == null) {
                refs = throwable;
            } else if (refs != throwable) {
                ((Throwable)refs).addSuppressed(throwable);
            }
            throw refs;
        }
        ArrayList<String> failed = new ArrayList<String>(2);
        LocalReplica.checkFailed(failed, accepted);
        LocalReplica.checkFailed(failed, committed);
        if (!failed.isEmpty()) {
            String[] arr = failed.toArray(new String[0]);
            req.setRefs(refdb.exactRef(arr));
        }
    }

    private static void checkFailed(List<String> failed, ReceiveCommand cmd) {
        if (cmd != null && cmd.getResult() != ReceiveCommand.Result.OK) {
            failed.add(cmd.getRefName());
        }
    }

    private boolean isOnlyTxnNamespace(Collection<ReceiveCommand> cmdList) {
        String txnNamespace = this.getSystem().getTxnNamespace();
        for (ReceiveCommand cmd : cmdList) {
            if (cmd.getRefName().startsWith(txnNamespace)) continue;
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(KetchText.get().outsideTxnNamespace, cmd.getRefName(), txnNamespace));
            ReceiveCommand.abort(cmdList);
            return false;
        }
        return true;
    }
}

