/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.NullProgressMonitor;
import org.openrewrite.shaded.jgit.lib.ProgressMonitor;
import org.openrewrite.shaded.jgit.util.IO;

public abstract class TemporaryBuffer
extends OutputStream {
    protected static final int DEFAULT_IN_CORE_LIMIT = 0x100000;
    ArrayList<Block> blocks;
    private int inCoreLimit;
    private int initialBlocks;
    private OutputStream overflow;

    protected TemporaryBuffer(int limit) {
        this(limit, limit);
    }

    protected TemporaryBuffer(int estimatedSize, int limit) {
        if (estimatedSize > limit) {
            throw new IllegalArgumentException();
        }
        this.inCoreLimit = limit;
        this.initialBlocks = (estimatedSize - 1) / 8192 + 1;
        this.reset();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.overflow != null) {
            this.overflow.write(b);
            return;
        }
        Block s = this.last();
        if (s.isFull()) {
            if (this.reachedInCoreLimit()) {
                this.overflow.write(b);
                return;
            }
            s = new Block();
            this.blocks.add(s);
        }
        s.buffer[s.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.overflow == null) {
            while (len > 0) {
                Block s = this.last();
                if (s.isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s = new Block();
                    this.blocks.add(s);
                }
                int n = Math.min(s.buffer.length - s.count, len);
                System.arraycopy(b, off, s.buffer, s.count, n);
                s.count += n;
                len -= n;
                off += n;
            }
        }
        if (len > 0) {
            this.overflow.write(b, off, len);
        }
    }

    protected void doFlush() throws IOException {
        if (this.overflow == null) {
            this.switchToOverflow();
        }
        this.overflow.flush();
    }

    public void copy(InputStream in) throws IOException {
        int n;
        if (this.blocks != null) {
            while (true) {
                Block s;
                if ((s = this.last()).isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s = new Block();
                    this.blocks.add(s);
                }
                if ((n = in.read(s.buffer, s.count, s.buffer.length - s.count)) < 1) {
                    return;
                }
                s.count += n;
            }
        }
        byte[] tmp = new byte[8192];
        while ((n = in.read(tmp)) > 0) {
            this.overflow.write(tmp, 0, n);
        }
    }

    public long length() {
        return this.inCoreLength();
    }

    private long inCoreLength() {
        Block last = this.last();
        return ((long)this.blocks.size() - 1L) * 8192L + (long)last.count;
    }

    public byte[] toByteArray() throws IOException {
        long len = this.length();
        if (Integer.MAX_VALUE < len) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        byte[] out = new byte[(int)len];
        int outPtr = 0;
        for (Block b : this.blocks) {
            System.arraycopy(b.buffer, 0, out, outPtr, b.count);
            outPtr += b.count;
        }
        return out;
    }

    public byte[] toByteArray(int limit) throws IOException {
        long len = Math.min(this.length(), (long)limit);
        if (Integer.MAX_VALUE < len) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        byte[] out = new byte[(int)len];
        int outPtr = 0;
        for (Block b : this.blocks) {
            System.arraycopy(b.buffer, 0, out, outPtr, b.count);
            outPtr += b.count;
        }
        return out;
    }

    public void writeTo(OutputStream os, ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        for (Block b : this.blocks) {
            os.write(b.buffer, 0, b.count);
            pm.update(b.count / 1024);
        }
    }

    public InputStream openInputStream() throws IOException {
        return new BlockInputStream();
    }

    public InputStream openInputStreamWithAutoDestroy() throws IOException {
        return new BlockInputStream(this){

            @Override
            public void close() throws IOException {
                super.close();
                this.destroy();
            }
        };
    }

    public void reset() {
        if (this.overflow != null) {
            this.destroy();
        }
        if (this.blocks != null) {
            this.blocks.clear();
        } else {
            this.blocks = new ArrayList(this.initialBlocks);
        }
        this.blocks.add(new Block(Math.min(this.inCoreLimit, 8192)));
    }

    protected abstract OutputStream overflow() throws IOException;

    private Block last() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    private boolean reachedInCoreLimit() throws IOException {
        if (this.inCoreLength() < (long)this.inCoreLimit) {
            return false;
        }
        this.switchToOverflow();
        return true;
    }

    private void switchToOverflow() throws IOException {
        this.overflow = this.overflow();
        Block last = this.blocks.remove(this.blocks.size() - 1);
        for (Block b : this.blocks) {
            this.overflow.write(b.buffer, 0, b.count);
        }
        this.blocks = null;
        this.overflow = new BufferedOutputStream(this.overflow, 8192);
        this.overflow.write(last.buffer, 0, last.count);
    }

    @Override
    public void close() throws IOException {
        if (this.overflow != null) {
            try {
                this.overflow.close();
            }
            finally {
                this.overflow = null;
            }
        }
    }

    public void destroy() {
        this.blocks = null;
        if (this.overflow != null) {
            try {
                try {
                    this.overflow.close();
                }
                catch (IOException iOException) {
                    this.overflow = null;
                }
            }
            finally {
                this.overflow = null;
            }
        }
    }

    static class Block {
        static final int SZ = 8192;
        final byte[] buffer;
        int count;

        Block() {
            this.buffer = new byte[8192];
        }

        Block(int sz) {
            this.buffer = new byte[sz];
        }

        boolean isFull() {
            return this.count == this.buffer.length;
        }
    }

    private class BlockInputStream
    extends InputStream {
        private byte[] singleByteBuffer;
        private int blockIndex;
        private Block block;
        private int blockPos;

        BlockInputStream() {
            this.block = TemporaryBuffer.this.blocks.get(this.blockIndex);
        }

        @Override
        public int read() throws IOException {
            int n;
            if (this.singleByteBuffer == null) {
                this.singleByteBuffer = new byte[1];
            }
            return (n = this.read(this.singleByteBuffer)) == 1 ? this.singleByteBuffer[0] & 0xFF : -1;
        }

        @Override
        public long skip(long cnt) throws IOException {
            long skipped = 0L;
            while (0L < cnt) {
                int n = (int)Math.min((long)(this.block.count - this.blockPos), cnt);
                if (n > 0) {
                    this.blockPos += n;
                    skipped += (long)n;
                    cnt -= (long)n;
                    continue;
                }
                if (!this.nextBlock()) break;
            }
            return skipped;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int copied = 0;
            while (len > 0) {
                int c = Math.min(this.block.count - this.blockPos, len);
                if (c > 0) {
                    System.arraycopy(this.block.buffer, this.blockPos, b, off, c);
                    this.blockPos += c;
                    off += c;
                    len -= c;
                    copied += c;
                    continue;
                }
                if (!this.nextBlock()) break;
            }
            return copied > 0 ? copied : -1;
        }

        private boolean nextBlock() {
            if (++this.blockIndex < TemporaryBuffer.this.blocks.size()) {
                this.block = TemporaryBuffer.this.blocks.get(this.blockIndex);
                this.blockPos = 0;
                return true;
            }
            return false;
        }
    }

    public static class Heap
    extends TemporaryBuffer {
        public Heap(int limit) {
            super(limit);
        }

        public Heap(int estimatedSize, int limit) {
            super(estimatedSize, limit);
        }

        @Override
        protected OutputStream overflow() throws IOException {
            throw new IOException(JGitText.get().inMemoryBufferLimitExceeded);
        }
    }

    public static class LocalFile
    extends TemporaryBuffer {
        private final File directory;
        private File onDiskFile;

        public LocalFile(File directory) {
            this(directory, 0x100000);
        }

        public LocalFile(File directory, int inCoreLimit) {
            super(inCoreLimit);
            this.directory = directory;
        }

        @Override
        protected OutputStream overflow() throws IOException {
            this.onDiskFile = File.createTempFile("jgit_", ".buf", this.directory);
            return new BufferedOutputStream(new FileOutputStream(this.onDiskFile));
        }

        @Override
        public long length() {
            if (this.onDiskFile == null) {
                return super.length();
            }
            return this.onDiskFile.length();
        }

        @Override
        public byte[] toByteArray() throws IOException {
            if (this.onDiskFile == null) {
                return super.toByteArray();
            }
            long len = this.length();
            if (Integer.MAX_VALUE < len) {
                throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
            }
            byte[] out = new byte[(int)len];
            Throwable throwable = null;
            Object var5_5 = null;
            try (FileInputStream in = new FileInputStream(this.onDiskFile);){
                IO.readFully(in, out, 0, (int)len);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return out;
        }

        @Override
        public void writeTo(OutputStream os, ProgressMonitor pm) throws IOException {
            if (this.onDiskFile == null) {
                super.writeTo(os, pm);
                return;
            }
            if (pm == null) {
                pm = NullProgressMonitor.INSTANCE;
            }
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream in = new FileInputStream(this.onDiskFile);){
                int cnt;
                byte[] buf = new byte[8192];
                while ((cnt = in.read(buf)) >= 0) {
                    os.write(buf, 0, cnt);
                    pm.update(cnt / 1024);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.onDiskFile == null) {
                return super.openInputStream();
            }
            return new FileInputStream(this.onDiskFile);
        }

        @Override
        public InputStream openInputStreamWithAutoDestroy() throws IOException {
            if (this.onDiskFile == null) {
                return super.openInputStreamWithAutoDestroy();
            }
            return new FileInputStream(this.onDiskFile){

                @Override
                public void close() throws IOException {
                    super.close();
                    this.destroy();
                }
            };
        }

        @Override
        public void destroy() {
            super.destroy();
            if (this.onDiskFile != null) {
                try {
                    if (!this.onDiskFile.delete()) {
                        this.onDiskFile.deleteOnExit();
                    }
                }
                finally {
                    this.onDiskFile = null;
                }
            }
        }
    }
}

