/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.shaded.jgit.errors.InvalidObjectIdException;
import org.openrewrite.shaded.jgit.errors.NoRemoteRepositoryException;
import org.openrewrite.shaded.jgit.errors.PackProtocolException;
import org.openrewrite.shaded.jgit.errors.RemoteRepositoryException;
import org.openrewrite.shaded.jgit.errors.TransportException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectIdRef;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.lib.SymbolicRef;
import org.openrewrite.shaded.jgit.transport.BaseConnection;
import org.openrewrite.shaded.jgit.transport.PackTransport;
import org.openrewrite.shaded.jgit.transport.PacketLineIn;
import org.openrewrite.shaded.jgit.transport.PacketLineOut;
import org.openrewrite.shaded.jgit.transport.Transport;
import org.openrewrite.shaded.jgit.transport.URIish;
import org.openrewrite.shaded.jgit.transport.UserAgent;
import org.openrewrite.shaded.jgit.util.io.InterruptTimer;
import org.openrewrite.shaded.jgit.util.io.TimeoutInputStream;
import org.openrewrite.shaded.jgit.util.io.TimeoutOutputStream;

abstract class BasePackConnection
extends BaseConnection {
    protected static final String CAPABILITY_SYMREF_PREFIX = "symref=";
    protected final Repository local;
    protected final URIish uri;
    protected final Transport transport;
    protected TimeoutInputStream timeoutIn;
    protected TimeoutOutputStream timeoutOut;
    private InterruptTimer myTimer;
    protected InputStream in;
    protected OutputStream out;
    protected PacketLineIn pckIn;
    protected PacketLineOut pckOut;
    protected boolean outNeedsEnd;
    protected boolean statelessRPC;
    private final Set<String> remoteCapablities = new HashSet<String>();
    protected final Set<ObjectId> additionalHaves = new HashSet<ObjectId>();

    BasePackConnection(PackTransport packTransport) {
        this.transport = (Transport)((Object)packTransport);
        this.local = this.transport.local;
        this.uri = this.transport.uri;
    }

    protected final void init(InputStream myIn, OutputStream myOut) {
        int timeout = this.transport.getTimeout();
        if (timeout > 0) {
            Thread caller = Thread.currentThread();
            if (this.myTimer == null) {
                this.myTimer = new InterruptTimer(String.valueOf(caller.getName()) + "-Timer");
            }
            this.timeoutIn = new TimeoutInputStream(myIn, this.myTimer);
            this.timeoutOut = new TimeoutOutputStream(myOut, this.myTimer);
            this.timeoutIn.setTimeout(timeout * 1000);
            this.timeoutOut.setTimeout(timeout * 1000);
            myIn = this.timeoutIn;
            myOut = this.timeoutOut;
        }
        this.in = myIn;
        this.out = myOut;
        this.pckIn = new PacketLineIn(this.in);
        this.pckOut = new PacketLineOut(this.out);
        this.outNeedsEnd = true;
    }

    protected void readAdvertisedRefs() throws TransportException {
        try {
            this.readAdvertisedRefsImpl();
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException | RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    private void readAdvertisedRefsImpl() throws IOException {
        LinkedHashMap<String, Ref> avail;
        block13: {
            String name;
            avail = new LinkedHashMap<String, Ref>();
            while (true) {
                Ref prior;
                ObjectId id;
                int nul;
                String line;
                try {
                    line = this.pckIn.readString();
                }
                catch (EOFException eof) {
                    if (avail.isEmpty()) {
                        throw this.noRepository();
                    }
                    throw eof;
                }
                if (PacketLineIn.isEnd(line)) break block13;
                if (line.startsWith("ERR ")) {
                    throw new RemoteRepositoryException(this.uri, line.substring(4));
                }
                if (avail.isEmpty() && (nul = line.indexOf(0)) >= 0) {
                    this.remoteCapablities.addAll(Arrays.asList(line.substring(nul + 1).split(" ")));
                    line = line.substring(0, nul);
                }
                if (line.length() < 41 || line.charAt(40) != ' ') {
                    throw this.invalidRefAdvertisementLine(line);
                }
                name = line.substring(41, line.length());
                if (avail.isEmpty() && name.equals("capabilities^{}")) continue;
                try {
                    id = ObjectId.fromString(line.substring(0, 40));
                }
                catch (InvalidObjectIdException e) {
                    PackProtocolException ppe = this.invalidRefAdvertisementLine(line);
                    ppe.initCause(e);
                    throw ppe;
                }
                if (name.equals(".have")) {
                    this.additionalHaves.add(id);
                    continue;
                }
                if (name.endsWith("^{}")) {
                    prior = avail.get(name = name.substring(0, name.length() - 3));
                    if (prior == null) {
                        throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().advertisementCameBefore, name, name));
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(String.valueOf(name) + "^{}");
                    }
                    avail.put(name, new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, prior.getObjectId(), id));
                    continue;
                }
                prior = avail.put(name, new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id));
                if (prior != null) break;
            }
            throw this.duplicateAdvertisement(name);
        }
        BasePackConnection.updateWithSymRefs(avail, BasePackConnection.extractSymRefsFromCapabilities(this.remoteCapablities));
        this.available(avail);
    }

    static Map<String, String> extractSymRefsFromCapabilities(Collection<String> capabilities) {
        LinkedHashMap<String, String> symRefs = new LinkedHashMap<String, String>();
        for (String option : capabilities) {
            String[] symRef;
            if (!option.startsWith(CAPABILITY_SYMREF_PREFIX) || (symRef = option.substring(CAPABILITY_SYMREF_PREFIX.length()).split(":", 2)).length != 2) continue;
            symRefs.put(symRef[0], symRef[1]);
        }
        return symRefs;
    }

    static void updateWithSymRefs(Map<String, Ref> refMap, Map<String, String> symRefs) {
        boolean haveNewRefMapEntries = !refMap.isEmpty();
        while (!symRefs.isEmpty() && haveNewRefMapEntries) {
            haveNewRefMapEntries = false;
            Iterator<Map.Entry<String, String>> iterator = symRefs.entrySet().iterator();
            while (iterator.hasNext()) {
                Ref r;
                Map.Entry<String, String> symRef = iterator.next();
                if (symRefs.containsKey(symRef.getValue()) || (r = refMap.get(symRef.getValue())) == null) continue;
                refMap.put(symRef.getKey(), new SymbolicRef(symRef.getKey(), r));
                haveNewRefMapEntries = true;
                iterator.remove();
            }
        }
    }

    protected TransportException noRepository() {
        return new NoRemoteRepositoryException(this.uri, JGitText.get().notFound);
    }

    protected boolean isCapableOf(String option) {
        return this.remoteCapablities.contains(option);
    }

    protected boolean wantCapability(StringBuilder b, String option) {
        if (!this.isCapableOf(option)) {
            return false;
        }
        b.append(' ');
        b.append(option);
        return true;
    }

    protected void addUserAgentCapability(StringBuilder b) {
        String a = UserAgent.get();
        if (a != null && UserAgent.hasAgent(this.remoteCapablities)) {
            b.append(' ').append("agent").append('=').append(a);
        }
    }

    @Override
    public String getPeerUserAgent() {
        return UserAgent.getAgent(this.remoteCapablities, super.getPeerUserAgent());
    }

    private PackProtocolException duplicateAdvertisement(String name) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, name));
    }

    private PackProtocolException invalidRefAdvertisementLine(String line) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().invalidRefAdvertisementLine, line));
    }

    @Override
    public void close() {
        block18: {
            block16: {
                if (this.out != null) {
                    try {
                        try {
                            if (this.outNeedsEnd) {
                                this.outNeedsEnd = false;
                                this.pckOut.end();
                            }
                            this.out.close();
                        }
                        catch (IOException iOException) {
                            this.out = null;
                            this.pckOut = null;
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        this.out = null;
                        this.pckOut = null;
                        throw throwable;
                    }
                    this.out = null;
                    this.pckOut = null;
                }
            }
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.in = null;
                        this.pckIn = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.in = null;
                    this.pckIn = null;
                    throw throwable;
                }
                this.in = null;
                this.pckIn = null;
            }
        }
        if (this.myTimer != null) {
            try {
                this.myTimer.terminate();
            }
            finally {
                this.myTimer = null;
                this.timeoutIn = null;
                this.timeoutOut = null;
            }
        }
    }

    protected void endOut() {
        if (this.outNeedsEnd && this.out != null) {
            try {
                this.outNeedsEnd = false;
                this.pckOut.end();
            }
            catch (IOException e) {
                try {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        this.out = null;
                        this.pckOut = null;
                    }
                }
                finally {
                    this.out = null;
                    this.pckOut = null;
                }
            }
        }
    }
}

