/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.Optional;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

@Incubating(since="7.0.0")
public interface SearchResult
extends Marker {
    public static final TreePrinter<Void> PRINTER = SearchResult.printer("~~>", "~~(%s)~~>");

    public static TreePrinter<Void> printer(final String markerText, final String markerTextWithDescription) {
        return new TreePrinter<Void>(){
            private SearchResult marker;
            private Integer mark;

            @Override
            public void doBefore(Tree tree, StringBuilder printerAcc, Void unused) {
                Optional<SearchResult> marker = tree.getMarkers().findFirst(SearchResult.class);
                if (marker.isPresent()) {
                    this.marker = marker.get();
                    this.mark = printerAcc.length();
                }
            }

            @Override
            public void doAfter(Tree tree, StringBuilder printerAcc, Void unused) {
                if (this.mark != null) {
                    for (int i = this.mark.intValue(); i < printerAcc.length(); ++i) {
                        if (Character.isWhitespace(printerAcc.charAt(i))) continue;
                        printerAcc.insert(i, this.marker.getDescription() == null ? markerText : String.format(markerTextWithDescription, this.marker.getDescription()));
                        break;
                    }
                    this.mark = null;
                }
            }
        };
    }

    @Nullable
    public String getDescription();
}

