/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.StreamSupport;
import org.openrewrite.Recipe;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.style.NamedStyles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningLoader
implements ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanningLoader.class);
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();

    public ClasspathScanningLoader(Iterable<Path> compileClasspath, Properties properties, String[] acceptPackages) {
        this.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties);
        this.scanClasses(new ClassGraph(), acceptPackages);
        if (compileClasspath.iterator().hasNext()) {
            URLClassLoader classpathLoader = new URLClassLoader((URL[])StreamSupport.stream(compileClasspath.spliterator(), false).map(cc -> {
                try {
                    return cc.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
            }).toArray(URL[]::new), this.getClass().getClassLoader());
            this.scanYaml(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classpathLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties);
            this.scanClasses(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classpathLoader}), acceptPackages);
        }
    }

    private void scanYaml(ClassGraph classGraph, Properties properties) {
        try (ScanResult scanResult = classGraph.enableMemoryMapping().scan();){
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> {
                YamlResourceLoader resourceLoader = new YamlResourceLoader(input, res.getURI(), properties);
                this.recipes.addAll(resourceLoader.listRecipes());
                this.styles.addAll(resourceLoader.listStyles());
            });
        }
    }

    private void scanClasses(ClassGraph classGraph, String[] acceptPackages) {
        try (ScanResult result = classGraph.ignoreClassVisibility().acceptPackages(acceptPackages).scan();){
            Constructor constructor;
            for (ClassInfo classInfo : result.getSubclasses(Recipe.class.getName())) {
                Class recipeClass = classInfo.loadClass();
                try {
                    constructor = recipeClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    this.recipes.add((Recipe)constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)recipeClass.getName(), (Object)e);
                }
            }
            for (ClassInfo classInfo : result.getSubclasses(NamedStyles.class.getName())) {
                Class styleClass = classInfo.loadClass();
                try {
                    constructor = styleClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    this.styles.add((NamedStyles)constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)styleClass.getName(), (Object)e);
                }
            }
        }
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.styles;
    }
}

