/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public abstract class TreeVisitor<T extends Tree, P> {
    private static final boolean IS_DEBUGGING = System.getProperty("org.openrewrite.debug") != null || ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    protected boolean cursored = IS_DEBUGGING;
    private Cursor cursor;
    private List<TreeVisitor<T, P>> afterVisit;

    protected final void setCursoringOn() {
        this.cursored = true;
        this.setCursor(new Cursor(null, "root"));
    }

    protected void setCursor(@Nullable Cursor cursor) {
        this.cursor = cursor;
    }

    protected void doAfterVisit(TreeVisitor<T, P> visitor) {
        this.afterVisit.add(visitor);
    }

    @Incubating(since="7.0.0")
    protected void doAfterVisit(Recipe recipe) {
        this.afterVisit.add(recipe.getVisitor());
    }

    protected List<TreeVisitor<T, P>> getAfterVisit() {
        return this.afterVisit;
    }

    public final Cursor getCursor() {
        if (this.cursor == null) {
            throw new IllegalStateException("Cursoring is not enabled for this visitor. Call setCursoringOn() in the visitor's constructor to enable.");
        }
        return this.cursor;
    }

    @Nullable
    public T preVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T postVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p, Cursor parent) {
        this.cursor = parent;
        return this.visit(tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p) {
        Tree t;
        if (tree == null) {
            return this.defaultValue(null, p);
        }
        boolean topLevel = false;
        if (this.afterVisit == null) {
            topLevel = true;
            this.afterVisit = new ArrayList<TreeVisitor<T, P>>();
        }
        if (this.cursored) {
            this.setCursor(new Cursor(this.cursor, tree));
        }
        if ((t = this.preVisit(tree, p)) != null) {
            t = t.accept(this, p);
        }
        if (t != null) {
            t = this.postVisit(t, p);
        }
        if (this.cursored) {
            this.setCursor(this.cursor.getParent());
        }
        if (topLevel) {
            if (t != null) {
                for (TreeVisitor<T, P> v : this.afterVisit) {
                    t = v.visit(t, p);
                }
            }
            this.afterVisit = null;
        }
        return (T)t;
    }

    @Nullable
    public T defaultValue(@Nullable Tree tree, P p) {
        return (T)tree;
    }

    @Incubating(since="7.0.0")
    protected <T2 extends Tree> T2 visitAndCast(T2 t, P p, BiFunction<T2, P, Tree> callSuper) {
        return (T2)callSuper.apply(t, p);
    }

    @Nullable
    @Incubating(since="7.0.0")
    protected <T2 extends T> T2 visitAndCast(@Nullable Tree tree, P p) {
        return (T2)this.visit(tree, p);
    }
}

