/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NullUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recipe {
    private static final Logger logger = LoggerFactory.getLogger(Recipe.class);
    private static final TreePrinter<ExecutionContext> MARKER_ID_PRINTER = new TreePrinter<ExecutionContext>(){

        @Override
        public void doBefore(@Nullable Tree tree, StringBuilder printerAcc, ExecutionContext executionContext) {
            String markerIds = tree.getMarkers().entries().stream().filter(marker -> !(marker instanceof RecipeThatMadeChanges)).map(marker -> String.valueOf(marker.hashCode())).collect(Collectors.joining(","));
            if (!markerIds.isEmpty()) {
                printerAcc.append("markers[").append(markerIds).append("]->");
            }
        }
    };
    public static final TreeVisitor<?, ExecutionContext> NOOP = new TreeVisitor<Tree, ExecutionContext>(){

        @Override
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            return tree;
        }
    };
    @Nullable
    private Recipe next;

    public Recipe doNext(Recipe recipe) {
        Recipe tail = this;
        while (tail.next != null) {
            tail = tail.next;
        }
        tail.next = recipe;
        return this;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return NOOP;
    }

    private <S extends SourceFile> List<SourceFile> visitInternal(List<S> before, ExecutionContext ctx) {
        List<SourceFile> after = before;
        if (this.validate(ctx).isValid()) {
            after = ListUtils.map(after, ctx.getForkJoinPool(), s -> {
                try {
                    SourceFile afterFile = (SourceFile)this.getVisitor().visit((Tree)s, ctx);
                    if (afterFile != null && afterFile != s) {
                        afterFile = (SourceFile)afterFile.withMarkers(afterFile.getMarkers().compute(new RecipeThatMadeChanges(this.getName()), (r1, r2) -> {
                            ((RecipeThatMadeChanges)r1).names.addAll(((RecipeThatMadeChanges)r2).names);
                            return r1;
                        }));
                    }
                    if (afterFile == null) {
                        ctx.recordSourceFileModification((SourceFile)s, this);
                    }
                    return afterFile;
                }
                catch (Throwable t) {
                    if (ctx.getOnError() != null) {
                        ctx.getOnError().accept(t);
                    }
                    return s;
                }
            });
        }
        List<SourceFile> afterWidened = this.visit(after, ctx);
        for (SourceFile maybeGenerated : afterWidened) {
            if (after.contains(maybeGenerated)) continue;
            ctx.recordSourceFileModification(maybeGenerated, this);
        }
        for (SourceFile maybeDeleted : after) {
            if (afterWidened.contains(maybeDeleted)) continue;
            ctx.recordSourceFileModification(maybeDeleted, this);
        }
        if (this.next != null) {
            afterWidened = this.next.visitInternal(afterWidened, ctx);
        }
        return afterWidened;
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return before;
    }

    public final List<Result> run(List<? extends SourceFile> before) {
        return this.run(before, ExecutionContext.builder().build());
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx) {
        List<? extends SourceFile> acc;
        List<? extends SourceFile> after = acc = before;
        for (int i = 0; i < ctx.getMaxCycles() && ((after = this.visitInternal(before, ctx)) != acc || ctx.isNeedAnotherCycle()); ++i) {
            acc = after;
            ctx.nextCycle();
        }
        if (after == before) {
            return Collections.emptyList();
        }
        Map sourceFileIdentities = before.stream().collect(Collectors.toMap(Tree::getId, Function.identity()));
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile : after) {
            SourceFile sourceFile2 = (SourceFile)sourceFileIdentities.get(sourceFile.getId());
            if (sourceFile2 == sourceFile) continue;
            if (sourceFile2 == null) {
                results.add(new Result(null, sourceFile, Collections.singleton(ctx.getRecipeThatModifiedSourceFile(sourceFile.getId()))));
                continue;
            }
            if (sourceFile2.print(MARKER_ID_PRINTER, ctx).equals(sourceFile.print(MARKER_ID_PRINTER, ctx))) continue;
            results.add(new Result(sourceFile2, sourceFile, sourceFile.getMarkers().findFirst(RecipeThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change?")).names));
        }
        Set afterIds = after.stream().map(Tree::getId).collect(Collectors.toSet());
        for (SourceFile sourceFile : before) {
            if (afterIds.contains(sourceFile.getId())) continue;
            results.add(new Result(sourceFile, null, Collections.singleton(ctx.getRecipeThatModifiedSourceFile(sourceFile.getId()))));
        }
        return results;
    }

    @Incubating(since="7.0.0")
    public Validated validate(ExecutionContext ctx) {
        return this.validate();
    }

    public Validated validate() {
        Validated validated = Validated.none();
        List<Field> requiredFields = NullUtils.findNonNullFields(this.getClass());
        for (Field field : requiredFields) {
            try {
                validated = validated.and(Validated.required(field.getName(), field.get(this)));
            }
            catch (IllegalAccessException e) {
                logger.warn("Unable to validate the field [{}] on the class [{}]", (Object)field.getName(), (Object)this.getClass().getName());
            }
        }
        return validated;
    }

    @Incubating(since="7.0.0")
    public final Collection<Validated> validateAll(ExecutionContext ctx) {
        return this.validateAll(ctx, new ArrayList<Validated>());
    }

    public final Collection<Validated> validateAll() {
        return this.validateAll(ExecutionContext.builder().build(), new ArrayList<Validated>());
    }

    private Collection<Validated> validateAll(ExecutionContext ctx, Collection<Validated> acc) {
        acc.add(this.validate(ctx));
        if (this.next != null) {
            this.next.validateAll(ctx, acc);
        }
        return acc;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.getName().equals(recipe.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    private static class RecipeThatMadeChanges
    implements Marker {
        private final Set<String> names = new HashSet<String>();

        private RecipeThatMadeChanges(String name) {
            this.names.add(name);
        }
    }
}

