/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;

public final class ExecutionContext {
    private volatile boolean needAnotherCycle = false;
    private final int maxCycles;
    @Nullable
    private final Consumer<Throwable> onError;
    private final ForkJoinPool forkJoinPool;
    private final Map<String, Object> messages = new ConcurrentHashMap<String, Object>();
    final Map<UUID, String> recipeThatModifiedSourceFile = new HashMap<UUID, String>();

    private ExecutionContext(int maxCycles, @Nullable Consumer<Throwable> onError, ForkJoinPool forkJoinPool) {
        this.maxCycles = maxCycles;
        this.onError = onError;
        this.forkJoinPool = forkJoinPool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void putMessage(String key, Object value) {
        this.needAnotherCycle = true;
        this.messages.put(key, value);
    }

    @Nullable
    public <T> T peekMessage(String key) {
        return (T)this.messages.get(key);
    }

    @Nullable
    public <T> T pollMessage(String key) {
        return (T)this.messages.remove(key);
    }

    boolean isNeedAnotherCycle() {
        return this.needAnotherCycle;
    }

    void nextCycle() {
        this.needAnotherCycle = false;
    }

    int getMaxCycles() {
        return this.maxCycles;
    }

    @Nullable
    Consumer<Throwable> getOnError() {
        return this.onError;
    }

    ForkJoinPool getForkJoinPool() {
        return this.forkJoinPool;
    }

    void recordSourceFileModification(SourceFile sourceFile, Recipe recipe) {
        this.recipeThatModifiedSourceFile.put(sourceFile.getId(), recipe.getName());
    }

    String getRecipeThatModifiedSourceFile(UUID sourceFileId) {
        return this.recipeThatModifiedSourceFile.get(sourceFileId);
    }

    public static class Builder {
        private int maxCycles = 3;
        @Nullable
        private Consumer<Throwable> onError;
        private ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();

        public Builder maxCycles(int maxCycles) {
            this.maxCycles = maxCycles;
            return this;
        }

        public Builder doOnError(@Nullable Consumer<Throwable> onError) {
            this.onError = onError;
            return this;
        }

        public Builder forkJoinPool(ForkJoinPool forkJoinPool) {
            this.forkJoinPool = forkJoinPool;
            return this;
        }

        public ExecutionContext build() {
            return new ExecutionContext(this.maxCycles, this.onError, this.forkJoinPool);
        }
    }
}

