/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.LatestRelease;

public class CaretRange
extends LatestRelease {
    private static final Pattern CARET_RANGE_PATTERN = Pattern.compile("\\^(\\d+)(?:\\.([*xX]|\\d+))?(?:\\.([*xX]|\\d+))?");
    private final String upperExclusive;
    private final String lower;

    private CaretRange(String lower, String upperExclusive, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.lower = lower;
        this.upperExclusive = upperExclusive;
    }

    @Override
    public boolean isValid(String version) {
        return super.isValid(version) && super.compare(version, this.upperExclusive) < 0 && super.compare(version, this.lower) >= 0;
    }

    public static Validated build(String pattern, @Nullable String metadataPattern) {
        Matcher matcher = CARET_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("caretRange", pattern, "not a caret range");
        }
        String major = matcher.group(1);
        String minor = CaretRange.normalizeWildcard(matcher.group(2));
        String patch = CaretRange.normalizeWildcard(matcher.group(3));
        if ("*".equals(minor) && matcher.group(3) != null) {
            return Validated.invalid("caretRange", pattern, "not a caret range: nothing can follow a wildcard");
        }
        String lower = minor == null ? major + ".0.0" : (patch == null ? major + "." + minor + ".0" : major + "." + minor + "." + patch);
        String upper = !"0".equals(major) || minor == null ? Integer.toString(Integer.parseInt(major) + 1) : (!"0".equals(minor) || patch == null ? major + "." + (Integer.parseInt(minor) + 1) : major + "." + minor + "." + patch);
        return Validated.valid("caretRange", new CaretRange(lower, upper, metadataPattern));
    }

    @Nullable
    private static String normalizeWildcard(@Nullable String part) {
        return "*".equals(part) || "x".equals(part) || "X".equals(part) ? null : part;
    }
}

