/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;

public class DeclarativeRecipe
extends Recipe {
    private final String name;
    private final URI source;
    private final List<String> lazyNext = new ArrayList<String>();
    private Validated validation = Validated.test("initialization", "initialize(..) must be called on DeclarativeRecipe prior to use.", this, r -> this.lazyNext.isEmpty());

    public DeclarativeRecipe(String name, URI source) {
        this.name = name;
        this.source = source;
    }

    void initialize(Collection<Recipe> availableRecipes) {
        for (String nextName : this.lazyNext) {
            Optional<Recipe> next = availableRecipes.stream().filter(r -> r.getName().equals(nextName)).findAny();
            if (next.isPresent()) {
                this.doNext(next.get());
                continue;
            }
            this.validation = this.validation.and(Validated.invalid("next", nextName, "Recipe '" + this.name + "' defined in '" + this.source + "' refers to a recipe name does not exist", null));
        }
        this.lazyNext.clear();
    }

    void doNext(String recipeName) {
        try {
            this.doNext((Recipe)Class.forName(recipeName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            this.lazyNext.add(recipeName);
        }
    }

    void addValidation(Validated validated) {
        this.validation = this.validation.and(validated);
    }

    @Override
    public Validated validate() {
        return this.validation;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

