/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;

public interface Parser<S extends SourceFile> {
    default public List<S> parse(Iterable<Path> sourceFiles, @Nullable Path relativeTo) {
        return this.parseInputs(StreamSupport.stream(sourceFiles.spliterator(), false).map(sourceFile -> new Input((Path)sourceFile, () -> {
            try {
                return Files.newInputStream(sourceFile, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).collect(Collectors.toList()), relativeTo);
    }

    default public S parse(Path sourceFile, @Nullable Path relativeTo) {
        return (S)((SourceFile)this.parse(Collections.singletonList(sourceFile), relativeTo).iterator().next());
    }

    default public List<S> parse(String ... sources) {
        return this.parseInputs(Arrays.stream(sources).map(source -> new Input(Paths.get(Long.toString(System.nanoTime()), new String[0]), () -> new ByteArrayInputStream(source.getBytes()), true)).collect(Collectors.toList()), null);
    }

    public List<S> parseInputs(Iterable<Input> var1, @Nullable Path var2);

    public boolean accept(Path var1);

    default public boolean accept(Input input) {
        return input.isSynthetic() || this.accept(input.getPath());
    }

    default public List<Input> acceptedInputs(Iterable<Input> input) {
        return StreamSupport.stream(input.spliterator(), false).filter(this::accept).collect(Collectors.toList());
    }

    default public Parser<S> reset() {
        return this;
    }

    public static interface Builder<S extends SourceFile> {
        public Parser<S> build();
    }

    public static class Input {
        private final boolean synthetic;
        private final Path path;
        private final Supplier<InputStream> source;

        public Input(Path path, Supplier<InputStream> source) {
            this(path, source, false);
        }

        public Input(Path path, Supplier<InputStream> source, boolean synthetic) {
            this.path = path;
            this.source = source;
            this.synthetic = synthetic;
        }

        public Path getPath() {
            return this.path;
        }

        public Path getRelativePath(@Nullable Path relativeTo) {
            return relativeTo == null ? this.path : relativeTo.relativize(this.path);
        }

        public InputStream getSource() {
            return this.source.get();
        }

        public boolean isSynthetic() {
            return this.synthetic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Input input = (Input)o;
            return Objects.equals(this.path, input.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }
    }
}

