/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.marker.Marker;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@Incubating(since="7.0.0")
public class Markers {
    public static Markers EMPTY = new Markers((Collection)Collections.emptyList()){

        public String toString() {
            return "markers{EMPTY}";
        }
    };
    private final Collection<Marker> markers;

    @JsonCreator
    public Markers(@JsonProperty(value="markers") Collection<Marker> markers) {
        this.markers = markers;
    }

    public Collection<Marker> entrySet() {
        return this.markers;
    }

    public Markers add(Marker marker) {
        ArrayList<Marker> updatedmarker = new ArrayList<Marker>(this.markers.size() + 1);
        updatedmarker.add(marker);
        return new Markers(updatedmarker);
    }

    public Markers addOrUpdate(Marker marker) {
        ArrayList<Marker> updatedmarker = new ArrayList<Marker>(this.markers.size() + 1);
        boolean updated = false;
        for (Marker m : this.markers) {
            if (m.getClass().equals(marker.getClass())) {
                updatedmarker.add(marker);
                updated = true;
                continue;
            }
            updatedmarker.add(m);
        }
        if (!updated) {
            updatedmarker.add(marker);
        }
        return new Markers(updatedmarker);
    }

    public <M extends Marker> Collection<M> findAll(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).collect(Collectors.toList());
    }

    public <M extends Marker> Optional<M> findFirst(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).findFirst();
    }
}

