/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.management.ManagementFactory;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public abstract class AbstractSourceVisitor<R>
implements SourceVisitor<R> {
    private static final boolean IS_DEBUGGING = System.getProperty("org.openrewrite.debug") != null || ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private boolean cursored = IS_DEBUGGING;
    private final ThreadLocal<Cursor> cursor = new ThreadLocal();

    protected void setCursoringOn() {
        this.cursored = true;
    }

    protected final R visitAfter(R r, @Nullable Tree tree) {
        return tree == null ? r : this.reduce(r, this.visit(tree));
    }

    protected final R visitAfter(R r, @Nullable List<? extends Tree> trees) {
        return this.reduce(r, this.visit(trees));
    }

    @Override
    public Cursor getCursor() {
        if (this.cursor.get() == null) {
            throw new IllegalStateException("Cursoring is not enabled for this visitor. Call setCursoringOn() in the visitor's constructor to enable.");
        }
        return this.cursor.get();
    }

    @Override
    public final R visit(@Nullable Tree tree) {
        if (tree == null) {
            return this.defaultTo(null);
        }
        if (this.cursored) {
            this.cursor.set(new Cursor(this.cursor.get(), tree));
        }
        Object t = this.reduce(tree.accept(this), this.visitTree(tree));
        if (this.cursored) {
            this.cursor.set(this.cursor.get().getParent());
        }
        return t;
    }
}

