/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.Style;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;

public class StyleConfiguration {
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private String name;
    private Map<String, Object> configure = new HashMap<String, Object>();

    public void setConfigure(Map<String, Object> configure) {
        this.configure = configure;
    }

    public Collection<Style> getStyles() {
        return this.configure.entrySet().stream().map(styleConfigByName -> {
            try {
                Style style = (Style)Class.forName((String)styleConfigByName.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                propertyConverter.updateValue((Object)style, styleConfigByName.getValue());
                return style;
            }
            catch (Exception e) {
                throw new ValidationException(Validated.invalid("className", styleConfigByName, "must be a fully-qualified class name on the classpath"));
            }
        }).collect(Collectors.toList());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

