/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;

public interface SourceVisitor<R> {
    default public Cursor getCursor() {
        throw new IllegalStateException("Cursoring is not enabled for this visitor");
    }

    default public Iterable<Tag> getTags() {
        return Tags.empty();
    }

    default public Validated validate() {
        return Validated.none();
    }

    default public String getName() {
        return this.getClass().getName();
    }

    public R defaultTo(@Nullable Tree var1);

    default public R reduce(R r1, R r2) {
        if (r1 instanceof Boolean) {
            return (R)Boolean.valueOf((Boolean)r1 != false || (Boolean)r2 != false);
        }
        if (r1 instanceof String) {
            return (R)(r1.toString() + (r2 == null ? "" : r2.toString()));
        }
        if (r1 instanceof Set) {
            return (R)Stream.concat(StreamSupport.stream(((Iterable)r1).spliterator(), false), StreamSupport.stream(((Iterable)r2).spliterator(), false)).collect(Collectors.toSet());
        }
        if (r1 instanceof Collection) {
            return (R)Stream.concat(StreamSupport.stream(((Iterable)r1).spliterator(), false), StreamSupport.stream(((Iterable)r2).spliterator(), false)).collect(Collectors.toList());
        }
        return r1 == null ? r2 : r1;
    }

    public R visit(@Nullable Tree var1);

    default public R visit(@Nullable List<? extends Tree> trees) {
        R r = this.defaultTo(null);
        if (trees != null) {
            for (Tree tree : trees) {
                if (tree == null) continue;
                r = this.reduce(r, this.visit(tree));
            }
        }
        return r;
    }

    default public R visitTree(Tree tree) {
        return this.defaultTo(tree);
    }
}

