/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.VersionComparator;

public class XRange
extends LatestRelease {
    private static final Pattern X_RANGE_PATTERN = Pattern.compile("([*xX]|\\d+)(?:\\.([*xX]|\\d+)(?:\\.([*xX]|\\d+))?)?");
    private final String major;
    private final String minor;
    private final String patch;

    XRange(String major, String minor, String patch, String metadataPattern) {
        super(metadataPattern);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Override
    public boolean isValid(String version) {
        if (!super.isValid(version)) {
            return false;
        }
        if (this.major.equals("*")) {
            return true;
        }
        Matcher gav = VersionComparator.RELEASE_PATTERN.matcher(XRange.normalizeVersion(version));
        gav.matches();
        if (!gav.group(1).equals(this.major)) {
            return false;
        }
        if (this.minor.equals("*")) {
            return true;
        }
        if (gav.group(2) == null || !gav.group(2).equals(this.minor)) {
            return false;
        }
        if (this.patch.equals("*")) {
            return true;
        }
        return gav.group(3) == null || !gav.group(3).equals(this.patch);
    }

    public static Validated build(String pattern, String metadataPattern) {
        Matcher matcher = X_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("xRange", pattern, "not an x-range");
        }
        String major = XRange.normalizeWildcard(matcher.group(1));
        String minor = XRange.normalizeWildcard(matcher.group(2) == null ? "0" : matcher.group(2));
        String patch = XRange.normalizeWildcard(matcher.group(3) == null ? "0" : matcher.group(3));
        if (major.equals("*") && (matcher.group(2) != null || matcher.group(3) != null)) {
            return Validated.invalid("xRange", pattern, "not an x-range: nothing can follow a wildcard");
        }
        if (minor.equals("*") && matcher.group(3) != null) {
            return Validated.invalid("xRange", pattern, "not an x-range: nothing can follow a wildcard");
        }
        return Validated.valid("xRange", new XRange(major, minor, patch, metadataPattern));
    }

    private static String normalizeWildcard(String part) {
        return part.equals("*") || part.equals("x") || part.equals("X") ? "*" : part;
    }
}

