/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.Recipe;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Style;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.config.AutoConfigureRefactorVisitorLoader;
import org.openrewrite.config.ClasspathResourceLoader;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    private final Map<String, Recipe> recipesByName;
    private final Collection<RefactorVisitor<?>> visitors;
    private final Map<String, Collection<Style>> stylesByName;

    private Environment(Collection<Recipe> recipes, Collection<RefactorVisitor<?>> visitors, Map<String, Collection<Style>> stylesByName) {
        this.recipesByName = recipes.stream().collect(Collectors.toMap(Recipe::getName, Function.identity()));
        this.visitors = visitors;
        this.stylesByName = stylesByName;
    }

    public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor, String ... recipes) {
        return this.configure(visitor, Arrays.asList(recipes));
    }

    public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor, Iterable<String> recipes) {
        return (R)this.loadedRecipes(recipes).stream().reduce(visitor, (v2, recipe) -> recipe.configure(v2), (v1, v2) -> v1);
    }

    public Map<String, Recipe> getRecipesByName() {
        return new HashMap<String, Recipe>(this.recipesByName);
    }

    public Collection<RefactorVisitor<?>> visitors(String ... recipes) {
        return this.visitors(Arrays.asList(recipes));
    }

    public Collection<RefactorVisitor<?>> visitors(Iterable<String> recipes) {
        List<Recipe> loadedRecipes = this.loadedRecipes(recipes);
        return this.visitors.stream().map(v -> loadedRecipes.stream().reduce(v, (v2, recipe) -> recipe.configure(v2), (v1, v2) -> v1)).filter(v -> loadedRecipes.stream().anyMatch(p -> p.accept((RefactorVisitor<?>)v).equals((Object)Recipe.FilterReply.ACCEPT))).collect(Collectors.toList());
    }

    public Collection<Style> styles(String ... styles) {
        return this.styles(Arrays.asList(styles));
    }

    public Collection<Style> styles(Iterable<String> styles) {
        return this.stylesByName.entrySet().stream().filter(namedStyles -> StreamSupport.stream(styles.spliterator(), false).anyMatch(s -> ((String)namedStyles.getKey()).equals(s))).flatMap(namedStyles -> ((Collection)namedStyles.getValue()).stream()).collect(Collectors.toList());
    }

    private List<Recipe> loadedRecipes(Iterable<String> recipes) {
        return StreamSupport.stream(recipes.spliterator(), false).map(this.recipesByName::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Builder builder(Properties properties) {
        return new Builder(properties);
    }

    public static Builder builder() {
        return new Builder(new Properties());
    }

    public static class Builder {
        private final Properties properties;
        private final Map<String, RecipeConfiguration> recipesConfigurations = new HashMap<String, RecipeConfiguration>();
        private final Collection<RefactorVisitor<?>> visitors = new ArrayList();
        private Iterable<Path> compileClasspath = Collections.emptyList();
        private final Map<String, Collection<Style>> stylesByName = new HashMap<String, Collection<Style>>();

        public Builder(Properties properties) {
            this.properties = properties;
        }

        public Builder compileClasspath(Iterable<Path> compileClasspath) {
            this.compileClasspath = Collections.emptyList();
            return this;
        }

        public Builder scanResources() {
            ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader(this.compileClasspath, this.properties);
            this.load(classpathResourceLoader);
            return this;
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                try (FileInputStream is = new FileInputStream(userHomeRewriteConfig);){
                    YamlResourceLoader resourceLoader = new YamlResourceLoader(is, userHomeRewriteConfig.toURI(), this.properties);
                    this.load(resourceLoader);
                }
                catch (IOException e) {
                    logger.warn("Unable to load ~/.rewrite/rewrite.yml.", (Throwable)e);
                }
                catch (ValidationException e) {
                    logger.warn("Unable to load ~/.rewrite/rewrite.yml", (Throwable)e);
                }
            }
            return this;
        }

        public Builder scanVisitors(String ... acceptVisitorPackages) {
            this.visitors.addAll(new AutoConfigureRefactorVisitorLoader(acceptVisitorPackages).loadVisitors());
            return this;
        }

        public Builder loadVisitors(Collection<? extends RefactorVisitor<?>> visitors) {
            this.visitors.addAll(visitors);
            return this;
        }

        public Builder load(ResourceLoader resourceLoader) {
            resourceLoader.loadRecipes().forEach(this::loadRecipe);
            this.visitors.addAll(resourceLoader.loadVisitors());
            this.stylesByName.putAll(resourceLoader.loadStyles());
            return this;
        }

        Builder loadRecipe(RecipeConfiguration recipeConfiguration) {
            Validated validated = Validated.required("recipeConfiguration.getName()", recipeConfiguration.getName()).and(Validated.test("recipeConfiguration.getName()", "Recipe name must be unique", recipeConfiguration.getName(), it -> !this.recipesConfigurations.containsKey(it)));
            if (validated.isInvalid()) {
                logger.warn(validated.toString());
            } else {
                this.recipesConfigurations.put(recipeConfiguration.getName(), recipeConfiguration);
            }
            return this;
        }

        public Environment build() {
            this.visitors.addAll(new AutoConfigureRefactorVisitorLoader("org.openrewrite").loadVisitors());
            return new Environment(this.recipesConfigurations.values().stream().map(RecipeConfiguration::build).collect(Collectors.toList()), this.visitors, this.stylesByName);
        }
    }
}

