/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.Recipe;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Style;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.config.AutoConfigureRefactorVisitorLoader;
import org.openrewrite.config.ClasspathResourceLoader;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.RecipeConfigurationLoader;
import org.openrewrite.config.RefactorVisitorLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefactorPlan {
    private static final Logger logger = LoggerFactory.getLogger(RefactorPlan.class);
    private final Map<String, Recipe> recipesByName;
    private final Collection<RefactorVisitor<?>> visitors;

    public RefactorPlan(Collection<Recipe> recipes, Collection<RefactorVisitor<?>> visitors) {
        this.recipesByName = recipes.stream().collect(Collectors.toMap(Recipe::getName, Function.identity()));
        this.visitors = visitors;
    }

    public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor, String ... recipes) {
        return this.configure(visitor, Arrays.asList(recipes));
    }

    public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor, Iterable<String> recipes) {
        return (R)this.loadedRecipes(recipes).stream().reduce(visitor, (v2, recipe) -> recipe.configure(v2), (v1, v2) -> v1);
    }

    public Map<String, Recipe> getRecipesByName() {
        return new HashMap<String, Recipe>(this.recipesByName);
    }

    @Nullable
    public <S extends Style> S style(Class<S> styleClass, Iterable<String> recipes) {
        return (S)((Style)this.loadedRecipes(recipes).stream().map(recipe -> recipe.getStyles().stream().filter(styleClass::isInstance).findFirst().orElse(null)).filter(Objects::nonNull).map(styleClass::cast).findFirst().orElse(null));
    }

    public Collection<RefactorVisitor<?>> visitors(String ... recipes) {
        return this.visitors(Arrays.asList(recipes));
    }

    public Collection<RefactorVisitor<?>> visitors(Iterable<String> recipes) {
        List<Recipe> loadedRecipes = this.loadedRecipes(recipes);
        return this.visitors.stream().map(v -> loadedRecipes.stream().reduce(v, (v2, recipe) -> recipe.configure(v2), (v1, v2) -> v1)).filter(v -> loadedRecipes.stream().anyMatch(p -> p.accept((RefactorVisitor<?>)v).equals((Object)Recipe.FilterReply.ACCEPT))).collect(Collectors.toList());
    }

    private List<Recipe> loadedRecipes(Iterable<String> recipes) {
        return StreamSupport.stream(recipes.spliterator(), false).map(this.recipesByName::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, RecipeConfiguration> recipesConfigurations = new HashMap<String, RecipeConfiguration>();
        private final Collection<RefactorVisitor<?>> visitors = new ArrayList();
        private Iterable<Path> compileClasspath = Collections.emptyList();

        public Builder compileClasspath(Iterable<Path> compileClasspath) {
            this.compileClasspath = Collections.emptyList();
            return this;
        }

        public Builder scanResources() {
            ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader(this.compileClasspath);
            this.loadVisitors(classpathResourceLoader);
            this.loadRecipes(classpathResourceLoader);
            return this;
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                try (FileInputStream is = new FileInputStream(userHomeRewriteConfig);){
                    YamlResourceLoader resourceLoader = new YamlResourceLoader(is);
                    this.loadVisitors(resourceLoader);
                    this.loadRecipes(resourceLoader);
                }
                catch (IOException e) {
                    logger.warn("Unable to load ~/.rewrite/rewrite.yml.", (Throwable)e);
                }
                catch (ValidationException e) {
                    logger.warn("Unable to load ~/.rewrite/rewrite.yml", (Throwable)e);
                }
            }
            return this;
        }

        public Builder scanVisitors(String ... acceptVisitorPackages) {
            this.visitors.addAll(new AutoConfigureRefactorVisitorLoader(acceptVisitorPackages).loadVisitors());
            return this;
        }

        public Builder loadVisitors(RefactorVisitorLoader refactorVisitorLoader) {
            this.visitors.addAll(refactorVisitorLoader.loadVisitors());
            return this;
        }

        public Builder loadVisitors(Collection<? extends RefactorVisitor<?>> visitors) {
            this.visitors.addAll(visitors);
            return this;
        }

        public Builder visitor(RefactorVisitor<?> visitor) {
            this.visitors.add(visitor);
            return this;
        }

        public Builder loadRecipes(RecipeConfigurationLoader recipeConfigurationLoader) {
            recipeConfigurationLoader.loadRecipes().forEach(this::loadRecipe);
            return this;
        }

        public Builder loadRecipe(RecipeConfiguration recipeConfiguration) {
            Validated validated = Validated.required("recipeConfiguration.getName()", recipeConfiguration.getName()).and(Validated.test("recipeConfiguration.getName()", "Recipe name must be unique", recipeConfiguration.getName(), it -> !this.recipesConfigurations.containsKey(it)));
            if (validated.isInvalid()) {
                throw new ValidationException(validated);
            }
            this.recipesConfigurations.put(recipeConfiguration.getName(), recipeConfiguration);
            return this;
        }

        public RefactorPlan build() {
            this.visitors.addAll(new AutoConfigureRefactorVisitorLoader("org.openrewrite").loadVisitors());
            return new RefactorPlan(this.recipesConfigurations.values().stream().map(pc -> pc.build(this.recipesConfigurations.values())).collect(Collectors.toList()), this.visitors);
        }
    }
}

