/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.ValidationException;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.RecipeConfigurationLoader;
import org.openrewrite.config.RefactorVisitorLoader;
import org.openrewrite.config.YamlResourceLoader;

public class ClasspathResourceLoader
implements RecipeConfigurationLoader,
RefactorVisitorLoader {
    private final Collection<YamlResourceLoader> yamlResourceLoaders = new ArrayList<YamlResourceLoader>();

    public ClasspathResourceLoader(Iterable<Path> compileClasspath) {
        try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}).enableMemoryMapping().scan();){
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> {
                try {
                    this.yamlResourceLoaders.add(new YamlResourceLoader(input));
                }
                catch (ValidationException e) {
                    throw new ValidationException(e, res.getURI());
                }
            });
        }
        if (compileClasspath.iterator().hasNext()) {
            scanResult = new ClassGraph().overrideClasspath(compileClasspath).acceptPaths(new String[]{"META-INF/rewrite"}).enableMemoryMapping().scan();
            try {
                scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> {
                    try {
                        this.yamlResourceLoaders.add(new YamlResourceLoader(input));
                    }
                    catch (ValidationException e) {
                        throw new ValidationException(e, res.getURI());
                    }
                });
            }
            finally {
                if (scanResult != null) {
                    scanResult.close();
                }
            }
        }
    }

    @Override
    public Collection<RecipeConfiguration> loadRecipes() {
        return this.yamlResourceLoaders.stream().flatMap(loader -> loader.loadRecipes().stream()).collect(Collectors.toList());
    }

    @Override
    public Collection<? extends RefactorVisitor<?>> loadVisitors() {
        return this.yamlResourceLoaders.stream().flatMap(loader -> loader.loadVisitors().stream()).collect(Collectors.toList());
    }
}

