/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.CompositeRefactorVisitor;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.RecipeConfigurationLoader;
import org.openrewrite.config.RefactorVisitorLoader;
import org.yaml.snakeyaml.Yaml;

public class YamlResourceLoader
implements RecipeConfigurationLoader,
RefactorVisitorLoader {
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Map<String, RecipeConfiguration> recipes = new HashMap<String, RecipeConfiguration>();
    private final Collection<CompositeRefactorVisitor> visitors = new ArrayList<CompositeRefactorVisitor>();
    private final Map<CompositeRefactorVisitor, String> visitorExtensions = new HashMap<CompositeRefactorVisitor, String>();
    public static final String visitorType = "openrewrite.org/v1beta/visitor";
    public static final String recipeType = "openrewrite.org/v1beta/recipe";
    private static final Set<String> validTypes = new LinkedHashSet<String>(Arrays.asList("openrewrite.org/v1beta/visitor", "openrewrite.org/v1beta/recipe"));
    private static final String validTypesString = String.join((CharSequence)", ", validTypes);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlResourceLoader(InputStream yamlInput) throws UncheckedIOException {
        try {
            try {
                Yaml yaml = new Yaml();
                for (Object t : yaml.loadAll(yamlInput)) {
                    if (!(t instanceof Map)) continue;
                    Map resourceMap = (Map)t;
                    String type = resourceMap.getOrDefault("type", "missing").toString();
                    Validated validation = Validated.required("type", type).and(Validated.test("type", "must be a valid rewrite type. These are the valid types: " + validTypesString, type, validTypes::contains));
                    if (validation.isInvalid()) {
                        throw new ValidationException(validation);
                    }
                    switch (type) {
                        case "openrewrite.org/v1beta/visitor": {
                            this.mapVisitor(resourceMap);
                            break;
                        }
                        case "openrewrite.org/v1beta/recipe": {
                            this.mapRecipe(resourceMap);
                        }
                    }
                }
                for (Map.Entry entry : this.visitorExtensions.entrySet()) {
                    this.visitors.stream().filter(v -> v.getName().equals(extendingVisitor.getValue())).findAny().ifPresent(v -> ((CompositeRefactorVisitor)extendingVisitor.getKey()).extendsFrom((CompositeRefactorVisitor)v));
                }
            }
            finally {
                yamlInput.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void mapVisitor(Map<String, Object> visitorMap) {
        Validated validation = Validated.required("name", visitorMap.get("name")).and(Validated.required("visitors", visitorMap.get("visitors"))).and(Validated.test("visitors", "must be a list", visitorMap.get("visitors"), visitors -> visitors instanceof List));
        if (validation.isInvalid()) {
            throw new ValidationException(validation);
        }
        ArrayList<RefactorVisitor<? extends Tree>> subVisitors = new ArrayList<RefactorVisitor<? extends Tree>>();
        for (Object subVisitorNameAndConfig : (List)visitorMap.get("visitors")) {
            try {
                if (subVisitorNameAndConfig instanceof String) {
                    subVisitors.add((RefactorVisitor)this.visitorClass((String)subVisitorNameAndConfig).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                if (!(subVisitorNameAndConfig instanceof Map)) continue;
                for (Map.Entry subVisitorEntry : ((Map)subVisitorNameAndConfig).entrySet()) {
                    RefactorVisitor subVisitor = (RefactorVisitor)this.visitorClass((String)subVisitorEntry.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    propertyConverter.updateValue((Object)subVisitor, subVisitorEntry.getValue());
                    subVisitors.add(subVisitor);
                }
            }
            catch (Exception e) {
                throw new ValidationException(Validated.invalid("visitor", subVisitorNameAndConfig, "must be constructable", e));
            }
        }
        CompositeRefactorVisitor visitor = new CompositeRefactorVisitor(visitorMap.get("name").toString(), subVisitors);
        if (visitorMap.containsKey("extends")) {
            this.visitorExtensions.put(visitor, visitorMap.get("extends").toString());
        }
        this.visitors.add(visitor);
    }

    private Class<?> visitorClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ignored) {
            return Class.forName("org.openrewrite." + name);
        }
    }

    private void mapRecipe(Map<String, Object> recipeMap) {
        RecipeConfiguration recipe = new RecipeConfiguration();
        try {
            propertyConverter.updateValue((Object)recipe, recipeMap);
        }
        catch (JsonMappingException e) {
            if (e.getCause() != null && e.getCause() instanceof ValidationException) {
                throw new ValidationException((ValidationException)e.getCause(), null);
            }
            throw new ValidationException(Validated.invalid("recipe", recipeMap, "must be a valid recipe configuration", e));
        }
        Validated validated = Validated.required("recipe.getName()", recipe.getName()).and(Validated.test("recipe.getName()", "there is already another recipe with that name", recipe.getName(), it -> !this.recipes.containsKey(it)));
        if (validated.isInvalid()) {
            throw new ValidationException(validated);
        }
        this.recipes.put(recipe.getName(), recipe);
    }

    @Override
    public Collection<RecipeConfiguration> loadRecipes() {
        return this.recipes.values();
    }

    @Override
    public Collection<? extends RefactorVisitor<?>> loadVisitors() {
        return this.visitors;
    }
}

