/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Profile;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Style;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ProfileConfiguration.class);
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Map<Class<? extends SourceVisitor>, Map<String, Object>> propertiesByVisitor = new IdentityHashMap<Class<? extends SourceVisitor>, Map<String, Object>>();
    private String name = "default";
    private String extend = null;
    private Set<Pattern> include = Collections.emptySet();
    private Set<Pattern> exclude = Collections.emptySet();
    private Map<String, Object> configure = new HashMap<String, Object>();
    private Map<String, Object> styles = new HashMap<String, Object>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public void setInclude(Set<String> include) {
        this.include = this.toPatternSet(include);
    }

    public void setExclude(Set<String> exclude) {
        this.exclude = this.toPatternSet(exclude);
    }

    public void setConfigure(Map<String, Object> configure) {
        this.configure = configure;
    }

    public void setStyles(Map<String, Object> styles) {
        this.styles = styles;
    }

    private Set<Pattern> toPatternSet(Set<String> set) {
        return set.stream().map(i -> i.replace(".", "\\.").replace("*", "[^.]+")).map(i -> "(org\\.openrewrite\\.)?" + i).map(Pattern::compile).collect(Collectors.toSet());
    }

    public ProfileConfiguration merge(@Nullable ProfileConfiguration profile) {
        if (profile != null && profile.name.equals(this.name)) {
            ProfileConfiguration merged = new ProfileConfiguration();
            merged.name = this.name;
            merged.include = Stream.concat(this.include.stream(), profile.include.stream()).collect(Collectors.toSet());
            merged.exclude = Stream.concat(this.exclude.stream(), profile.exclude.stream()).collect(Collectors.toSet());
            merged.configure = this.configure;
            merged.configure.putAll(profile.configure);
            merged.styles.putAll(profile.styles);
            return merged;
        }
        return this;
    }

    public Profile build(Collection<ProfileConfiguration> otherProfileConfigurations) {
        Map configsByName = otherProfileConfigurations.stream().collect(Collectors.toMap(ProfileConfiguration::getName, Function.identity()));
        final ArrayDeque<ProfileConfiguration> inOrderConfigurations = new ArrayDeque<ProfileConfiguration>();
        LinkedList<ProfileConfiguration> configs = new LinkedList<ProfileConfiguration>();
        configs.add(this);
        while (!configs.isEmpty()) {
            ProfileConfiguration parent;
            ProfileConfiguration config = (ProfileConfiguration)configs.poll();
            inOrderConfigurations.add(config);
            if (config.extend == null || (parent = (ProfileConfiguration)configsByName.get(config.extend)) == null) continue;
            configs.add(parent);
        }
        if (!this.name.equals("default") && configsByName.containsKey("default")) {
            inOrderConfigurations.add((ProfileConfiguration)configsByName.get("default"));
        }
        return new Profile(){

            @Override
            public String getName() {
                return ProfileConfiguration.this.name;
            }

            @Override
            public Collection<Style> getStyles() {
                return inOrderConfigurations.stream().flatMap(conf -> ((ProfileConfiguration)conf).styles.entrySet().stream().map(styleConfigByName -> {
                    try {
                        Style style = (Style)Class.forName((String)styleConfigByName.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        propertyConverter.updateValue((Object)style, styleConfigByName.getValue());
                        return style;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to load style with class name '" + styleConfigByName + "'", (Throwable)e);
                        return null;
                    }
                }).filter(Objects::nonNull)).collect(Collectors.toList());
            }

            @Override
            public Profile.FilterReply accept(RefactorVisitor<?> visitor) {
                return inOrderConfigurations.stream().reduce(Profile.FilterReply.NEUTRAL, (reply, config) -> reply.equals((Object)Profile.FilterReply.NEUTRAL) ? ((ProfileConfiguration)config).accept(visitor) : reply, (r1, r2) -> r1.equals((Object)Profile.FilterReply.NEUTRAL) ? r2 : r1);
            }

            @Override
            public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor) {
                Iterator configs = inOrderConfigurations.descendingIterator();
                while (configs.hasNext()) {
                    ((ProfileConfiguration)configs.next()).configure(visitor);
                }
                return visitor;
            }
        };
    }

    private void configure(SourceVisitor<?> visitor) {
        try {
            propertyConverter.updateValue(visitor, this.propertyMap(visitor));
        }
        catch (JsonMappingException e) {
            logger.warn("Unable to configure {}", (Object)visitor.getClass().getName(), (Object)e);
        }
    }

    protected Map<String, Object> propertyMap(SourceVisitor<?> visitor) {
        return this.propertiesByVisitor.computeIfAbsent(visitor.getClass(), clazz -> this.propertyMap(clazz.getName(), this.configure));
    }

    private Map<String, Object> propertyMap(String partialName, @Nullable Object config) {
        if (!(config instanceof Map)) {
            return Collections.emptyMap();
        }
        Map configMap = (Map)config;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int nextDot = partialName.indexOf(46);
        while (nextDot != -1) {
            String subpackage = partialName.substring(0, nextDot);
            String remaining = partialName.substring(nextDot + 1);
            for (Map.Entry configEntry : configMap.entrySet()) {
                if (!Pattern.compile(((String)configEntry.getKey()).replace("*", ".+")).matcher(subpackage).matches()) continue;
                properties.putAll(this.propertyMap(remaining, configEntry.getValue()));
            }
            nextDot = partialName.indexOf(46, nextDot + 1);
        }
        block2: for (Map.Entry configEntry : configMap.entrySet()) {
            Matcher matcher;
            HashMap value;
            String keyPart = (String)configEntry.getKey();
            if (configEntry.getValue() instanceof Map) {
                value = (HashMap)configEntry.getValue();
            } else {
                value = new HashMap();
                value.put(keyPart.substring(keyPart.lastIndexOf(46) + 1), configEntry.getValue());
                keyPart = keyPart.substring(0, Math.max(0, keyPart.lastIndexOf(46)));
            }
            do {
                if ((matcher = Pattern.compile("^" + keyPart.replace("*", ".+")).matcher(partialName)).find()) {
                    properties.putAll(value);
                    continue block2;
                }
                if (!matcher.hitEnd()) continue;
                HashMap value2 = new HashMap();
                value2.put(keyPart.substring(keyPart.lastIndexOf(46) + 1), value);
                value = value2;
                keyPart = keyPart.substring(0, keyPart.lastIndexOf(46));
            } while (matcher.hitEnd());
        }
        return properties;
    }

    private Profile.FilterReply accept(SourceVisitor<?> visitor) {
        if (visitor.validate().isInvalid() || this.exclude.stream().anyMatch(i -> i.matcher(visitor.getName()).matches())) {
            return Profile.FilterReply.DENY;
        }
        if (this.include.stream().anyMatch(i -> i.matcher(visitor.getName()).matches())) {
            return Profile.FilterReply.ACCEPT;
        }
        return Profile.FilterReply.NEUTRAL;
    }
}

