/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.Profile;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Style;
import org.openrewrite.Tree;
import org.openrewrite.config.AutoConfigureRefactorVisitorLoader;
import org.openrewrite.config.ClasspathResourceLoader;
import org.openrewrite.config.ProfileConfiguration;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.openrewrite.config.RefactorVisitorLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefactorPlan {
    private static final Logger logger = LoggerFactory.getLogger(RefactorPlan.class);
    private final Map<String, Profile> profilesByName;
    private final Collection<RefactorVisitor<?>> visitors;

    public RefactorPlan(Collection<Profile> profiles, Collection<RefactorVisitor<?>> visitors) {
        this.profilesByName = profiles.stream().collect(Collectors.toMap(Profile::getName, Function.identity()));
        this.visitors = visitors;
    }

    public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor, String ... profiles) {
        return this.configure(visitor, Arrays.asList(profiles));
    }

    public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor, Iterable<String> profiles) {
        return (R)this.loadedProfiles(profiles).stream().reduce(visitor, (v2, profile) -> profile.configure(v2), (v1, v2) -> v1);
    }

    @Nullable
    public <S extends Style> S style(Class<S> styleClass, Iterable<String> profiles) {
        return (S)((Style)this.loadedProfiles(profiles).stream().map(profile -> profile.getStyles().stream().filter(styleClass::isInstance).findFirst().orElse(null)).filter(Objects::nonNull).map(styleClass::cast).findFirst().orElse(null));
    }

    public Collection<RefactorVisitor<?>> visitors(String ... profiles) {
        return this.visitors(Arrays.asList(profiles));
    }

    public Collection<RefactorVisitor<?>> visitors(Iterable<String> profiles) {
        List<Profile> loadedProfiles = this.loadedProfiles(profiles);
        return this.visitors.stream().map(v -> loadedProfiles.stream().reduce(v, (v2, profile) -> profile.configure(v2), (v1, v2) -> v1)).filter(v -> loadedProfiles.stream().anyMatch(p -> p.accept((RefactorVisitor<?>)v).equals((Object)Profile.FilterReply.ACCEPT))).collect(Collectors.toList());
    }

    private List<Profile> loadedProfiles(Iterable<String> profiles) {
        return StreamSupport.stream(profiles.spliterator(), false).map(this.profilesByName::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, ProfileConfiguration> profileConfigurations = new HashMap<String, ProfileConfiguration>();
        private final Collection<RefactorVisitor<?>> visitors = new ArrayList();
        private Iterable<Path> compileClasspath = Collections.emptyList();

        public Builder compileClasspath(Iterable<Path> compileClasspath) {
            this.compileClasspath = Collections.emptyList();
            return this;
        }

        public Builder scanResources() {
            ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader(this.compileClasspath);
            this.loadVisitors(classpathResourceLoader);
            this.loadProfiles(classpathResourceLoader);
            return this;
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                try (FileInputStream is = new FileInputStream(userHomeRewriteConfig);){
                    YamlResourceLoader resourceLoader = new YamlResourceLoader(is);
                    this.loadVisitors(resourceLoader);
                    this.loadProfiles(resourceLoader);
                }
                catch (IOException e) {
                    logger.warn("Unable to load ~/.rewrite/rewrite.yml.", (Throwable)e);
                }
            }
            return this;
        }

        public Builder scanVisitors(String ... acceptVisitorPackages) {
            this.visitors.addAll(new AutoConfigureRefactorVisitorLoader(acceptVisitorPackages).loadVisitors());
            return this;
        }

        public Builder loadVisitors(RefactorVisitorLoader refactorVisitorLoader) {
            this.visitors.addAll(refactorVisitorLoader.loadVisitors());
            return this;
        }

        public Builder loadVisitors(Collection<? extends RefactorVisitor<?>> visitors) {
            this.visitors.addAll(visitors);
            return this;
        }

        public Builder visitor(RefactorVisitor<?> visitor) {
            this.visitors.add(visitor);
            return this;
        }

        public Builder loadProfiles(ProfileConfigurationLoader profileConfigurationLoader) {
            profileConfigurationLoader.loadProfiles().forEach(this::loadProfile);
            return this;
        }

        public Builder loadProfile(ProfileConfiguration profileConfiguration) {
            this.profileConfigurations.compute(profileConfiguration.getName(), (name, existing) -> profileConfiguration.merge((ProfileConfiguration)existing));
            return this;
        }

        public RefactorPlan build() {
            this.visitors.addAll(new AutoConfigureRefactorVisitorLoader("org.openrewrite").loadVisitors());
            return new RefactorPlan(this.profileConfigurations.values().stream().map(pc -> pc.build(this.profileConfigurations.values())).collect(Collectors.toList()), this.visitors);
        }
    }
}

