/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public class Cursor {
    @Nullable
    private final Cursor parent;
    private final Tree tree;

    public Iterator<Tree> getPath() {
        return new CursorIterator(this);
    }

    public Stream<Tree> getPathAsStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getPath(), 0), false);
    }

    @Nullable
    public <T extends Tree> T firstEnclosing(Class<T> tClass) {
        CursorIterator iter = new CursorIterator(this);
        while (iter.hasNext()) {
            Tree t = iter.next();
            if (!tClass.isInstance(t)) continue;
            return (T)t;
        }
        return null;
    }

    public String toString() {
        return "Cursor{" + StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getPath(), 0), false).map(t -> t.getClass().getSimpleName()).collect(Collectors.joining("->")) + "}";
    }

    @Nullable
    public Cursor getParent() {
        return this.parent;
    }

    public Cursor getParentOrThrow() {
        if (this.parent == null) {
            throw new IllegalStateException("Expected to find a parent for " + this);
        }
        return this.parent;
    }

    public <T extends Tree> T getTree() {
        return (T)this.tree;
    }

    public boolean isScopeInPath(Tree scope) {
        return this.tree != null && this.tree.getId().equals(scope.getId()) || this.getPathAsStream().anyMatch(p -> p.getId().equals(scope.getId()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cursor)) {
            return false;
        }
        Cursor other = (Cursor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cursor this$parent = this.getParent();
        Cursor other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Object this$tree = this.getTree();
        Object other$tree = other.getTree();
        return !(this$tree == null ? other$tree != null : !this$tree.equals(other$tree));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cursor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Object $tree = this.getTree();
        result = result * 59 + ($tree == null ? 43 : $tree.hashCode());
        return result;
    }

    public Cursor(Cursor parent, Tree tree) {
        this.parent = parent;
        this.tree = tree;
    }

    private static class CursorIterator
    implements Iterator<Tree> {
        private Cursor cursor;

        private CursorIterator(Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public Tree next() {
            Tree t = this.cursor.tree;
            this.cursor = this.cursor.parent;
            return t;
        }
    }
}

