/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.git;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.openrewrite.Change;
import org.openrewrite.ChangePublisher;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.git.GitMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating(since="2.0.0")
public class GitChangePublisher
implements ChangePublisher {
    private static final Logger logger = LoggerFactory.getLogger(GitChangePublisher.class);
    private final String user;
    private final String password;
    private final String commitMessage;

    @Override
    public void publish(Collection<Change<SourceFile>> changes) {
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.user, this.password);
        try {
            InMemoryRepository repository = new InMemoryRepository.Builder().build();
            Git git = new Git((Repository)repository);
            git.add().addFilepattern("gradle-enterprise.xml").call();
            git.commit().setMessage(this.commitMessage).setAuthor("jkschneider", "jkschneider@gmail.com").call();
        }
        catch (IOException | GitAPIException e) {
            logger.warn("Unable to commit change", e);
        }
    }

    public void publishChangesForRepository(Collection<Change<SourceFile>> changes) {
        Change<SourceFile> change = changes.iterator().next();
        Optional<GitMetadata> gitMetadata = change.getFixed().getMetadata(GitMetadata.class);
    }

    public GitChangePublisher(String user, String password, String commitMessage) {
        this.user = user;
        this.password = password;
        this.commitMessage = commitMessage;
    }
}

