/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.Profile;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceGenerator;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.config.AutoConfigureSourceVisitorLoader;
import org.openrewrite.config.ClasspathResourceLoader;
import org.openrewrite.config.CompositeRefactorVisitor;
import org.openrewrite.config.ProfileConfiguration;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.openrewrite.config.SourceVisitorLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefactorPlan {
    private static final Logger logger = LoggerFactory.getLogger(RefactorPlan.class);
    private final Map<String, Profile> profilesByName;
    private final Collection<SourceVisitor<?>> visitors;

    public RefactorPlan(Collection<Profile> profiles, Collection<SourceVisitor<?>> visitors) {
        this.profilesByName = profiles.stream().collect(Collectors.toMap(Profile::getName, Function.identity()));
        this.visitors = visitors;
    }

    public <T extends Tree, S extends SourceVisitor<T>> S configure(S visitor, String ... profiles) {
        return this.configure(visitor, Arrays.asList(profiles));
    }

    public <T extends Tree, S extends SourceVisitor<T>> S configure(S visitor, Iterable<String> profiles) {
        List loadedProfiles = StreamSupport.stream(profiles.spliterator(), false).map(this.profilesByName::get).filter(Objects::nonNull).collect(Collectors.toList());
        visitor = loadedProfiles.stream().reduce(visitor, (v2, profile) -> profile.configure(v2), (v1, v2) -> v1);
        return visitor;
    }

    public <T extends Tree, S extends SourceVisitor<T>> Collection<S> visitors(Class<T> sourceType, String ... profiles) {
        return this.visitors(sourceType, Arrays.asList(profiles));
    }

    public <T extends Tree, S extends SourceVisitor<T>> Collection<S> visitors(Class<T> sourceType, Iterable<String> profiles) {
        List loadedProfiles = StreamSupport.stream(profiles.spliterator(), false).map(this.profilesByName::get).filter(Objects::nonNull).collect(Collectors.toList());
        return this.visitors.stream().filter(v -> {
            Type genericSuperclass = v.getClass().getGenericSuperclass();
            if (CompositeRefactorVisitor.class.equals(v.getClass())) {
                genericSuperclass = ((CompositeRefactorVisitor)v).getVisitorType().getGenericSuperclass();
                while (genericSuperclass != null && !(genericSuperclass instanceof ParameterizedType)) {
                    genericSuperclass = ((Class)genericSuperclass).getGenericSuperclass();
                }
            }
            if (genericSuperclass instanceof ParameterizedType) {
                Type[] sourceFileType = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
                return sourceFileType[0].equals(sourceType);
            }
            return true;
        }).map(v -> v).map(v -> loadedProfiles.stream().reduce(v, (v2, profile) -> profile.configure(v2), (v1, v2) -> v1)).filter(v -> loadedProfiles.stream().anyMatch(p -> p.accept(v).equals((Object)Profile.FilterReply.ACCEPT))).collect(Collectors.toList());
    }

    public <S extends SourceFile, G extends SourceGenerator<S>> Collection<G> generators(Class<G> sourceType, String ... profiles) {
        return this.generators(sourceType, Arrays.asList(profiles));
    }

    public <S extends SourceFile, G extends SourceGenerator<S>> Collection<G> generators(Class<G> sourceType, Iterable<String> profiles) {
        return this.visitors(sourceType, profiles).stream().filter(SourceGenerator.class::isInstance).map(SourceGenerator.class::cast).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, ProfileConfiguration> profileConfigurations = new HashMap<String, ProfileConfiguration>();
        private final Collection<SourceVisitor<?>> visitors = new ArrayList();
        private Iterable<Path> compileClasspath = Collections.emptyList();

        public Builder compileClasspath(Iterable<Path> compileClasspath) {
            this.compileClasspath = Collections.emptyList();
            return this;
        }

        public Builder scanResources() {
            ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader(this.compileClasspath);
            this.loadVisitors(classpathResourceLoader);
            this.loadProfiles(classpathResourceLoader);
            return this;
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                try (FileInputStream is = new FileInputStream(userHomeRewriteConfig);){
                    YamlResourceLoader resourceLoader = new YamlResourceLoader(is);
                    this.loadVisitors(resourceLoader);
                    this.loadProfiles(resourceLoader);
                }
                catch (IOException e) {
                    logger.warn("Unable to load ~/.rewrite/rewrite.yml.", (Throwable)e);
                }
            }
            return this;
        }

        public Builder scanVisitors(String ... acceptVisitorPackages) {
            this.visitors.addAll(new AutoConfigureSourceVisitorLoader(acceptVisitorPackages).loadVisitors());
            return this;
        }

        public Builder loadVisitors(SourceVisitorLoader sourceVisitorLoader) {
            this.visitors.addAll(sourceVisitorLoader.loadVisitors());
            return this;
        }

        public Builder visitor(SourceVisitor<?> visitor) {
            this.visitors.add(visitor);
            return this;
        }

        public Builder loadProfiles(ProfileConfigurationLoader profileConfigurationLoader) {
            profileConfigurationLoader.loadProfiles().forEach(this::loadProfile);
            return this;
        }

        public Builder loadProfile(ProfileConfiguration profileConfiguration) {
            this.profileConfigurations.compute(profileConfiguration.getName(), (name, existing) -> profileConfiguration.merge((ProfileConfiguration)existing));
            return this;
        }

        public RefactorPlan build() {
            this.visitors.addAll(new AutoConfigureSourceVisitorLoader("org.openrewrite").loadVisitors());
            return new RefactorPlan(this.profileConfigurations.values().stream().map(pc -> pc.build(this.profileConfigurations.values())).collect(Collectors.toList()), this.visitors);
        }
    }
}

