/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openrewrite.Change;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNullApi;

@NonNullApi
public class Refactor<T extends Tree> {
    private final T original;
    private MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final List<SourceVisitor<? extends Tree>> visitors = new ArrayList<SourceVisitor<? extends Tree>>();

    public Refactor(T original) {
        this.original = original;
    }

    @SafeVarargs
    public final Refactor<T> visit(SourceVisitor<? extends Tree> ... visitors) {
        Collections.addAll(this.visitors, visitors);
        return this;
    }

    public final Refactor<T> visit(Iterable<SourceVisitor<? extends Tree>> visitors) {
        visitors.forEach(this.visitors::add);
        return this;
    }

    public Change<T> fix() {
        return this.fix(10);
    }

    public Change<T> fix(int maxCycles) {
        Timer.Sample sample = Timer.start();
        T acc = this.original;
        HashSet<String> rulesThatMadeChanges = new HashSet<String>();
        for (int i = 0; i < maxCycles; ++i) {
            HashSet<String> rulesThatMadeChangesThisCycle = new HashSet<String>();
            for (SourceVisitor<? extends Tree> visitor : this.visitors) {
                T before;
                visitor.nextCycle();
                if (!visitor.isIdempotent() && i > 0 || (before = acc) == (acc = this.transformPipeline(acc, visitor))) continue;
                rulesThatMadeChangesThisCycle.add(visitor.getClass().getName());
            }
            if (rulesThatMadeChangesThisCycle.isEmpty()) break;
            rulesThatMadeChanges.addAll(rulesThatMadeChangesThisCycle);
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.plan").description("The time it takes to execute a refactoring plan consisting of potentially more than one visitor over more than one cycle").tag("tree.type", this.original.getClass().getSimpleName()).tag("outcome", rulesThatMadeChanges.isEmpty() ? "Unchanged" : "Changed").register(this.meterRegistry));
        for (String ruleThatMadeChange : rulesThatMadeChanges) {
            Counter.builder((String)"rewrite.refactor.plan.changes").description("The number of changes requested by a visitor.").tag("visitor", ruleThatMadeChange).tag("tree.type", this.original.getClass().getSimpleName()).register(this.meterRegistry).increment();
        }
        return new Change<T>(this.original, acc, rulesThatMadeChanges);
    }

    private T transformPipeline(T acc, SourceVisitor<? extends Tree> visitor) {
        Timer.Sample sample = Timer.start();
        acc = visitor.visit((Tree)acc);
        for (SourceVisitor<? extends Tree> vis : visitor.andThen()) {
            acc = this.transformPipeline(acc, vis);
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.visit").description("The time it takes to visit a single AST with a particular refactoring visitor and its pipeline").tag("visitor", visitor.getClass().getName()).tags(visitor.getTags()).tag("tree.type", this.original.getClass().getSimpleName()).register(this.meterRegistry));
        return acc;
    }

    public Refactor<T> setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public T getOriginal() {
        return this.original;
    }

    public List<SourceVisitor<? extends Tree>> getVisitors() {
        return this.visitors;
    }
}

