/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openrewrite.SourceVisitor;
import org.openrewrite.config.ProfileConfiguration;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.openrewrite.config.SourceVisitorLoader;
import org.openrewrite.config.YamlResourceLoader;

public class ClasspathResourceLoader
implements ProfileConfigurationLoader,
SourceVisitorLoader {
    private final Collection<YamlResourceLoader> yamlResourceLoaders = new ArrayList<YamlResourceLoader>();

    public ClasspathResourceLoader(Iterable<Path> compileClasspath) {
        try (ScanResult scanResult = new ClassGraph().whitelistPaths(new String[]{"META-INF/rewrite"}).enableMemoryMapping().scan();){
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> this.yamlResourceLoaders.add(new YamlResourceLoader(input)));
        }
        if (compileClasspath.iterator().hasNext()) {
            scanResult = new ClassGraph().overrideClasspath(compileClasspath).whitelistPaths(new String[]{"META-INF/rewrite"}).enableMemoryMapping().scan();
            try {
                scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> this.yamlResourceLoaders.add(new YamlResourceLoader(input)));
            }
            finally {
                if (scanResult != null) {
                    scanResult.close();
                }
            }
        }
    }

    @Override
    public Collection<ProfileConfiguration> loadProfiles() {
        return this.yamlResourceLoaders.stream().flatMap(loader -> loader.loadProfiles().stream()).collect(Collectors.toList());
    }

    @Override
    public Collection<SourceVisitor<?>> loadVisitors() {
        return this.yamlResourceLoaders.stream().flatMap(loader -> loader.loadVisitors().stream()).collect(Collectors.toList());
    }
}

