/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtils {
    public static String trimIndent(String text) {
        int indentLevel = StringUtils.indentLevel(text);
        StringBuilder trimmed = new StringBuilder();
        int[] charArray = text.stripTrailing().chars().dropWhile(c -> c == 10 || c == 13).toArray();
        for (int i = 0; i < charArray.length; ++i) {
            int j;
            boolean nonWhitespaceEncountered = false;
            for (j = i; j < charArray.length; ++j) {
                int c2 = charArray[j];
                if (j - i >= indentLevel || (nonWhitespaceEncountered |= !Character.isWhitespace(c2))) {
                    trimmed.append((char)c2);
                }
                if (c2 == 13 || c2 == 10) break;
            }
            i = j;
        }
        return trimmed.toString();
    }

    static int indentLevel(String text) {
        Stream<String> lines = text.stripTrailing().lines();
        SortedMap indentFrequencies = lines.dropWhile(String::isEmpty).map(l -> (int)l.chars().takeWhile(Character::isWhitespace).count()).collect(Collectors.groupingBy(Function.identity(), TreeMap::new, Collectors.counting()));
        return StringUtils.mostCommonIndent(indentFrequencies);
    }

    public static int mostCommonIndent(SortedMap<Integer, Long> indentFrequencies) {
        TreeMap<Integer, Integer> indentFrequencyAsDivisors = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Long> indentFrequency : indentFrequencies.entrySet()) {
            int freq;
            int indent = indentFrequency.getKey();
            switch (indent) {
                case 0: {
                    freq = indentFrequency.getValue().intValue();
                    break;
                }
                case 1: {
                    freq = (int)indentFrequencies.tailMap(indent).values().stream().mapToLong(l -> l).sum();
                    break;
                }
                default: {
                    freq = (int)indentFrequencies.tailMap(indent).entrySet().stream().filter(inF -> StringUtils.gcd((Integer)inF.getKey(), indent) != 0).mapToLong(Map.Entry::getValue).sum();
                }
            }
            indentFrequencyAsDivisors.put(indent, freq);
        }
        if (indentFrequencies.getOrDefault(0, 0L) > 1L) {
            return 0;
        }
        return indentFrequencyAsDivisors.entrySet().stream().max((e1, e2) -> {
            int valCompare = ((Integer)e1.getValue()).compareTo((Integer)e2.getValue());
            return valCompare != 0 ? valCompare : ((Integer)e1.getKey() == 0 ? -1 : ((Integer)e2.getKey()).compareTo((Integer)e1.getKey()));
        }).map(Map.Entry::getKey).orElse(0);
    }

    static int gcd(int n1, int n2) {
        return n2 == 0 ? n1 : StringUtils.gcd(n2, n1 % n2);
    }
}

