/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.config.SourceVisitorLoader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlSourceVisitorLoader
implements SourceVisitorLoader {
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final String name;
    private final InputStream yamlInput;

    public YamlSourceVisitorLoader(String name, InputStream yaml) {
        this.name = name;
        this.yamlInput = yaml;
    }

    @Override
    public Collection<SourceVisitor<?>> load() {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(YamlSourceVisitorConfiguration.class));
        CompositeSourceVisitor compositeVisitor = ((YamlSourceVisitorConfiguration)yaml.load((InputStream)this.yamlInput)).compositeVisitor;
        return compositeVisitor == null ? Collections.emptyList() : Collections.singletonList(compositeVisitor.setName(this.name));
    }

    public static class CompositeSourceVisitor
    extends SourceVisitor<Object> {
        private String name;
        private final List<SourceVisitor<Object>> delegates;

        public CompositeSourceVisitor(List<SourceVisitor<Object>> delegates) {
            this.name = this.name;
            this.delegates = delegates;
            delegates.forEach(this::andThen);
        }

        @Override
        public Iterable<Tag> getTags() {
            return Tags.of((String)"name", (String)this.name);
        }

        CompositeSourceVisitor setName(String name) {
            this.name = name;
            return this;
        }

        public Class<?> getVisitorType() {
            return this.delegates.stream().findAny().map(Object::getClass).orElse(null);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object defaultTo(Tree t) {
            return this.delegates.stream().findAny().map(v -> v.defaultTo(t)).orElse(null);
        }
    }

    public static class YamlSourceVisitorConfiguration {
        private CompositeSourceVisitor compositeVisitor;

        public void setVisitors(List<Object> subVisitorsMap) {
            ArrayList<SourceVisitor<Object>> subVisitors = new ArrayList<SourceVisitor<Object>>();
            for (Object subVisitorNameAndConfig : subVisitorsMap) {
                try {
                    if (subVisitorNameAndConfig instanceof String) {
                        subVisitors.add((SourceVisitor)this.visitorClass((String)subVisitorNameAndConfig).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        continue;
                    }
                    if (!(subVisitorNameAndConfig instanceof Map)) continue;
                    for (Map.Entry subVisitorEntry : ((Map)subVisitorNameAndConfig).entrySet()) {
                        SourceVisitor subVisitor = (SourceVisitor)this.visitorClass((String)subVisitorEntry.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        propertyConverter.updateValue((Object)subVisitor, subVisitorEntry.getValue());
                        subVisitors.add(subVisitor);
                    }
                }
                catch (Exception e) {
                    throw new ValidationException(Validated.invalid("visitor", subVisitorNameAndConfig, "must be constructable", e));
                }
            }
            this.compositeVisitor = new CompositeSourceVisitor(subVisitors);
        }

        private Class<?> visitorClass(String name) throws ClassNotFoundException {
            try {
                return Class.forName(name.toString());
            }
            catch (ClassNotFoundException ignored) {
                return Class.forName("org.openrewrite." + name);
            }
        }
    }
}

