/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.SourceVisitor;
import org.openrewrite.config.SourceVisitorLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigureSourceVisitorLoader
implements SourceVisitorLoader {
    private static final Logger logger = LoggerFactory.getLogger(AutoConfigureSourceVisitorLoader.class);
    private final String[] whitelistVisitorPackages;

    public AutoConfigureSourceVisitorLoader(String ... whitelistVisitorPackages) {
        this.whitelistVisitorPackages = whitelistVisitorPackages;
    }

    @Override
    public Collection<SourceVisitor<?>> load() {
        try (ScanResult scanResult = new ClassGraph().whitelistPackages(this.whitelistVisitorPackages).enableMemoryMapping().enableMethodInfo().enableAnnotationInfo().ignoreClassVisibility().ignoreMethodVisibility().scan();){
            Collection collection = scanResult.getClassesWithAnnotation(AutoConfigure.class.getName()).stream().map(classInfo -> {
                Class visitorClass = classInfo.loadClass();
                try {
                    Constructor constructor = visitorClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return (SourceVisitor)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)visitorClass.getName(), (Object)e);
                    return null;
                }
            }).collect(Collectors.toList());
            return collection;
        }
    }
}

