/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.Profile;
import org.openrewrite.config.ProfileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlProfileSource
implements ProfileSource {
    private static final Logger logger = LoggerFactory.getLogger(YamlProfileSource.class);
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();

    public YamlProfileSource(InputStream yaml) {
        try (InputStream i = yaml;){
            Constructor constructor = new Constructor(Profile.class);
            TypeDescription profileDesc = new TypeDescription(Profile.class);
            profileDesc.substituteProperty("profile", String.class, "getName", "setName", new Class[0]);
            constructor.addTypeDescription(profileDesc);
            for (Object profileObj : new Yaml((BaseConstructor)constructor).loadAll(i)) {
                Profile profile = (Profile)profileObj;
                this.profiles.compute(profile.getName(), (name, existing) -> profile.merge((Profile)existing));
            }
        }
        catch (IOException e) {
            logger.warn("Unable to load YAML profile source", (Throwable)e);
        }
    }

    @Override
    public Collection<Profile> load() {
        return this.profiles.values();
    }
}

