/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;

public class CompositeSourceVisitor<T>
extends SourceVisitor<T> {
    private final String name;
    private final List<SourceVisitor<T>> delegates;

    public CompositeSourceVisitor(String name, List<SourceVisitor<T>> delegates) {
        this.name = name;
        this.delegates = delegates;
        delegates.forEach(this::andThen);
    }

    @Override
    public Iterable<Tag> getTags() {
        return Tags.of((String)"name", (String)this.name);
    }

    public String getName() {
        return this.name;
    }

    public List<SourceVisitor<T>> getDelegates() {
        return this.delegates;
    }

    @Override
    public T defaultTo(Tree t) {
        return this.delegates.stream().findAny().map(v -> v.defaultTo(t)).orElse(null);
    }
}

