/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.openrewrite.Change;
import org.openrewrite.Environment;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNullApi;

@NonNullApi
public class Refactor<S extends SourceFile, T extends Tree> {
    private final S original;
    private MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final List<SourceVisitor<T>> visitors = new ArrayList<SourceVisitor<T>>();

    public Refactor(S original) {
        this.original = original;
    }

    @SafeVarargs
    public final Refactor<S, T> visit(SourceVisitor<T> ... visitors) {
        Collections.addAll(this.visitors, visitors);
        return this;
    }

    public final Refactor<S, T> visit(Iterable<SourceVisitor<T>> visitors) {
        visitors.forEach(this.visitors::add);
        return this;
    }

    public final Refactor<S, T> activateProfiles(Environment environment, String ... profiles) {
        for (String profileName : profiles) {
            this.visit(environment.getProfile(profileName).getVisitorsForSourceType(this.original.getClass()));
        }
        return this;
    }

    public final <T2 extends T> Refactor<S, T> fold(Iterable<T2> ts, Function<T2, SourceVisitor<T>> refactorForEach) {
        return StreamSupport.stream(ts.spliterator(), false).map(refactorForEach).filter(Objects::nonNull).reduce(this, (rec$, xva$0) -> ((Refactor)rec$).visit((SourceVisitor)xva$0), (r1, r2) -> r2);
    }

    public Change<S> fix() {
        return this.fix(10);
    }

    public Change<S> fix(int maxCycles) {
        Timer.Sample sample = Timer.start();
        S acc = this.original;
        HashSet<String> rulesThatMadeChanges = new HashSet<String>();
        for (int i = 0; i < maxCycles; ++i) {
            HashSet<String> rulesThatMadeChangesThisCycle = new HashSet<String>();
            for (SourceVisitor<T> visitor : this.visitors) {
                S before;
                visitor.nextCycle();
                if (!visitor.isIdempotent() && i > 0 || (before = acc) == (acc = this.transformPipeline(acc, visitor))) continue;
                rulesThatMadeChangesThisCycle.add(visitor.getClass().getName());
            }
            if (rulesThatMadeChangesThisCycle.isEmpty()) break;
            rulesThatMadeChanges.addAll(rulesThatMadeChangesThisCycle);
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.plan").description("The time it takes to execute a refactoring plan consisting of potentially more than one visitor over more than one cycle").tag("file.type", this.original.getFileType()).tag("outcome", rulesThatMadeChanges.isEmpty() ? "Unchanged" : "Changed").register(this.meterRegistry));
        for (String ruleThatMadeChange : rulesThatMadeChanges) {
            Counter.builder((String)"rewrite.refactor.plan.changes").description("The number of changes requested by a visitor.").tag("visitor", ruleThatMadeChange).tag("file.type", this.original.getFileType()).register(this.meterRegistry).increment();
        }
        return new Change<S>(this.original, acc, rulesThatMadeChanges);
    }

    private S transformPipeline(S acc, SourceVisitor<T> visitor) {
        Timer.Sample sample = Timer.start();
        acc = (SourceFile)visitor.visit((Tree)acc);
        for (SourceVisitor<T> vis : visitor.andThen()) {
            acc = this.transformPipeline(acc, vis);
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.visit").description("The time it takes to visit a single AST with a particular refactoring visitor and its pipeline").tag("visitor", visitor.getClass().getName()).tags(visitor.getTags()).tag("file.type", this.original.getFileType()).register(this.meterRegistry));
        return acc;
    }

    public Refactor<S, T> setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public S getOriginal() {
        return this.original;
    }

    public List<SourceVisitor<T>> getVisitors() {
        return this.visitors;
    }
}

