/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.config.CompositeSourceVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profile {
    private static final Logger logger = LoggerFactory.getLogger(Profile.class);
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    public static final Profile EMPTY = new Profile();
    private String name = "default";
    private Set<Pattern> include = Collections.emptySet();
    private Set<Pattern> exclude = Collections.emptySet();
    private Set<String> extend = Collections.emptySet();
    private final List<CompositeSourceVisitor<?>> define = new ArrayList();
    private final Map<Class<? extends SourceVisitor>, Map<String, Object>> propertiesByVisitor = new IdentityHashMap<Class<? extends SourceVisitor>, Map<String, Object>>();
    private final Map<Type, Collection<SourceVisitor<?>>> includedVisitorsBySourceType = new HashMap();
    private Map<String, Object> configure = Collections.emptyMap();

    public void setName(@Nullable String name) {
        this.name = name == null ? "default" : name;
    }

    public void setProfile(@Nullable String name) {
        this.setName(name);
    }

    public void setInclude(Set<String> include) {
        this.include = this.toPatternSet(include);
    }

    public void setExclude(Set<String> exclude) {
        this.exclude = this.toPatternSet(exclude);
    }

    public void setExtend(Set<String> extend) {
        this.extend = extend;
    }

    public void setConfigure(Map<String, Object> configure) {
        this.configure = configure;
    }

    public void setDefine(Map<String, Object> define) {
        Map<String, List<Object>> definitionsByName = this.definitionsByName("", define);
        for (Map.Entry<String, List<Object>> visitorsByCompositeName : definitionsByName.entrySet()) {
            ArrayList visitors = new ArrayList();
            for (Object visitorObject : visitorsByCompositeName.getValue()) {
                Object value = null;
                Object visitorClassName = visitorObject;
                if (visitorObject instanceof Map) {
                    Map.Entry visitorEntry = ((Map)visitorObject).entrySet().iterator().next();
                    visitorClassName = visitorEntry.getKey();
                    value = visitorEntry.getValue();
                }
                try {
                    Class<?> visitorClass;
                    try {
                        visitorClass = Class.forName(visitorClassName.toString());
                    }
                    catch (ClassNotFoundException ignored) {
                        visitorClass = Class.forName("org.openrewrite." + visitorClassName);
                    }
                    SourceVisitor visitor = (SourceVisitor)visitorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    propertyConverter.updateValue((Object)visitor, value);
                    visitors.add(visitor);
                }
                catch (Exception e) {
                    throw new ValidationException(Validated.invalid("define", visitorClassName, "must be constructable", e));
                }
            }
            this.define.add(new CompositeSourceVisitor(visitorsByCompositeName.getKey(), visitors));
        }
    }

    private Map<String, List<Object>> definitionsByName(String prefix, Map<String, Object> define) {
        return define.entrySet().stream().flatMap(e -> {
            String nextPrefix = prefix.isEmpty() ? (String)e.getKey() : prefix + "." + (String)e.getKey();
            Object value = e.getValue();
            if (value instanceof Map) {
                return this.definitionsByName(nextPrefix, (Map)value).entrySet().stream();
            }
            if (value instanceof List) {
                return Stream.of(Map.entry(nextPrefix, (List)value));
            }
            throw new ValidationException(Validated.invalid("define." + prefix + "." + (String)e.getKey(), value, "should be a list of visitors"));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Set<Pattern> toPatternSet(Set<String> set) {
        return set.stream().map(i -> i.replace(".", "\\.").replace("*", ".+")).map(i -> "(org\\.openrewrite\\.)?" + i).map(Pattern::compile).collect(Collectors.toUnmodifiableSet());
    }

    public <S, T extends SourceVisitor<S>> T configure(T visitor) {
        try {
            propertyConverter.updateValue(visitor, this.propertyMap(visitor));
        }
        catch (JsonMappingException e) {
            logger.warn("Unable to configure {}", (Object)visitor.getClass().getName(), (Object)e);
        }
        return visitor;
    }

    protected Map<String, Object> propertyMap(SourceVisitor<?> visitor) {
        return this.propertiesByVisitor.computeIfAbsent(visitor.getClass(), clazz -> this.propertyMap(clazz.getName(), this.configure));
    }

    private Map<String, Object> propertyMap(String partialName, @Nullable Object config) {
        if (!(config instanceof Map)) {
            return Collections.emptyMap();
        }
        Map configMap = (Map)config;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int nextDot = partialName.indexOf(46);
        while (nextDot != -1) {
            String subpackage = partialName.substring(0, nextDot);
            String remaining = partialName.substring(nextDot + 1);
            for (Map.Entry configEntry : configMap.entrySet()) {
                if (!Pattern.compile(((String)configEntry.getKey()).replace("*", ".+")).matcher(subpackage).matches()) continue;
                properties.putAll(this.propertyMap(remaining, configEntry.getValue()));
            }
            nextDot = partialName.indexOf(46, nextDot + 1);
        }
        block2: for (Map.Entry configEntry : configMap.entrySet()) {
            Matcher matcher;
            Map<String, Object> value;
            String keyPart = (String)configEntry.getKey();
            if (configEntry.getValue() instanceof Map) {
                value = (Map)configEntry.getValue();
            } else {
                value = Map.of(keyPart.substring(keyPart.lastIndexOf(46) + 1), configEntry.getValue());
                keyPart = keyPart.substring(0, Math.max(0, keyPart.lastIndexOf(46)));
            }
            do {
                if ((matcher = Pattern.compile("^" + keyPart.replace("*", ".+")).matcher(partialName)).find()) {
                    properties.putAll(value);
                    continue block2;
                }
                if (!matcher.hitEnd()) continue;
                value = Map.of(keyPart.substring(keyPart.lastIndexOf(46) + 1), value);
                keyPart = keyPart.substring(0, keyPart.lastIndexOf(46));
            } while (matcher.hitEnd());
        }
        return properties;
    }

    public Profile merge(@Nullable Profile profile) {
        if (profile != null && profile.getName().equals(this.name)) {
            Profile merged = new Profile();
            merged.name = this.name;
            merged.include = Stream.concat(this.include.stream(), profile.include.stream()).collect(Collectors.toUnmodifiableSet());
            merged.exclude = Stream.concat(this.exclude.stream(), profile.exclude.stream()).collect(Collectors.toUnmodifiableSet());
            merged.configure = this.configure;
            merged.configure.putAll(profile.configure);
            return merged;
        }
        return this;
    }

    public boolean maybeAdd(SourceVisitor<?> visitor) {
        String visitorName = visitor.getClass().getName();
        if (visitor.validate().isValid() && this.getInclude().stream().anyMatch(i -> i.matcher(visitorName).matches()) && this.getExclude().stream().noneMatch(e -> e.matcher(visitorName).matches())) {
            Type genericSuperclass = visitor.getClass().getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType) {
                Type[] sourceFileType = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
                this.includedVisitorsBySourceType.computeIfAbsent(sourceFileType[0], t -> new ArrayList()).add(visitor);
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    protected List<CompositeSourceVisitor<?>> getDefinitions() {
        return this.define;
    }

    <T extends Tree> Collection<SourceVisitor<T>> getVisitorsForSourceType(Class<T> t) {
        return Stream.concat(((Collection)this.includedVisitorsBySourceType.getOrDefault(t, Collections.emptyList())).stream(), this.getDefinitions().stream().filter(definition -> this.getInclude().stream().anyMatch(i -> i.matcher(definition.getName()).matches()))).map(v -> v).collect(Collectors.toList());
    }

    protected Set<String> getExtend() {
        return this.extend;
    }

    protected Set<Pattern> getInclude() {
        return this.include;
    }

    protected Set<Pattern> getExclude() {
        return this.exclude;
    }
}

