/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Profile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.config.CompositeSourceVisitor;
import org.openrewrite.config.ProfileSource;
import org.openrewrite.config.YamlProfileSource;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    private final Map<String, Profile> profiles;

    private Environment(Collection<Profile> profiles) {
        this.profiles = profiles.stream().collect(Collectors.toMap(Profile::getName, Function.identity()));
    }

    public static Builder builder() {
        return new Builder();
    }

    Profile getProfile(String profile) {
        return this.profiles.getOrDefault(profile, Profile.EMPTY);
    }

    public static class Builder {
        private final Map<String, Profile> profiles = new HashMap<String, Profile>();

        public final Builder loadProfile(ProfileSource profileSource) {
            for (Profile profile : profileSource.load()) {
                this.profiles.compute(profile.getName(), (name, existing) -> profile.merge((Profile)existing));
            }
            return this;
        }

        public final Builder scanProfiles(String ... whitelistResources) {
            try (ScanResult result = new ClassGraph().whitelistPaths(whitelistResources).enableMemoryMapping().scan();){
                for (Resource resource : result.getAllResources()) {
                    if (!resource.getPath().endsWith(".yml")) {
                        if (!resource.getPath().endsWith(".yaml")) continue;
                    }
                    this.scanProfileYaml(() -> ((Resource)resource).open());
                }
            }
            return this;
        }

        public final Builder scanProfiles(Path ... paths) {
            for (Path path : paths) {
                File file = path.toFile();
                if (!file.getName().endsWith(".yml") && !file.getName().endsWith(".yaml")) continue;
                this.scanProfileYaml(() -> new FileInputStream(file));
            }
            return this;
        }

        private void scanProfileYaml(Callable<InputStream> is) {
            try (InputStream yaml = is.call();){
                this.loadProfile(new YamlProfileSource(yaml));
            }
            catch (Exception e) {
                logger.warn("Unable to scan profile YML", (Throwable)e);
            }
        }

        public final Environment scan(String ... whitelistPackages) {
            List<Profile> compositeProfiles = this.profiles.values().stream().map(x$0 -> new CompositeProfile((Profile)x$0)).collect(Collectors.toList());
            try (ScanResult scanResult = new ClassGraph().whitelistPackages(whitelistPackages).enableMemoryMapping().enableMethodInfo().enableAnnotationInfo().ignoreClassVisibility().ignoreMethodVisibility().scan();){
                for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(AutoConfigure.class.getName())) {
                    Class visitorClass = classInfo.loadClass();
                    for (Profile profile : compositeProfiles) {
                        try {
                            Constructor constructor = visitorClass.getConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            SourceVisitor visitor = profile.configure((SourceVisitor)constructor.newInstance(new Object[0]));
                            profile.maybeAdd(visitor);
                        }
                        catch (Exception e) {
                            logger.warn("Unable to configure {}", (Object)visitorClass.getName(), (Object)e);
                        }
                    }
                }
            }
            return new Environment(compositeProfiles);
        }

        class CompositeProfile
        extends Profile {
            private final List<Profile> profileChain;

            CompositeProfile(Profile rootProfile) {
                this.profileChain = this.extendedProfilesDepthFirst(rootProfile);
                if (rootProfile != null) {
                    this.setName(rootProfile.getName());
                }
            }

            private List<Profile> extendedProfilesDepthFirst(@Nullable Profile profile) {
                if (profile == null) {
                    return Collections.emptyList();
                }
                return Stream.concat(profile.getExtend().stream().map(Builder.this.profiles::get).filter(Objects::nonNull).flatMap(p -> this.extendedProfilesDepthFirst((Profile)p).stream()), Stream.of(profile)).collect(Collectors.toList());
            }

            @Override
            protected Set<Pattern> getInclude() {
                return this.profileChain.stream().flatMap(p -> p.getInclude().stream()).collect(Collectors.toSet());
            }

            @Override
            protected Set<Pattern> getExclude() {
                return this.profileChain.stream().flatMap(p -> p.getExclude().stream()).collect(Collectors.toSet());
            }

            @Override
            protected List<CompositeSourceVisitor<?>> getDefinitions() {
                return this.profileChain.stream().flatMap(p -> p.getDefinitions().stream()).collect(Collectors.toList());
            }

            @Override
            protected Map<String, Object> propertyMap(SourceVisitor<?> visitor) {
                HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                for (Profile profile : this.profileChain) {
                    propertyMap.putAll(profile.propertyMap(visitor));
                }
                return propertyMap;
            }
        }
    }
}

