/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.openrewrite.config.MapConfigSource;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigSource
extends MapConfigSource {
    public YamlConfigSource(InputStream yaml) {
        super(YamlConfigSource.yamlToMap(yaml));
    }

    @Override
    public String getValue(String propertyName) {
        return super.getValue(propertyName.toLowerCase().replace("-", ""));
    }

    @Override
    public String getName() {
        return "yaml";
    }

    public static Config yamlConfig(String yaml) {
        return ConfigProviderResolver.instance().getBuilder().addDiscoveredSources().addDiscoveredConverters().withSources(new ConfigSource[]{new YamlConfigSource(new ByteArrayInputStream(yaml.getBytes(Charset.defaultCharset())))}).build();
    }

    private static Map<String, String> yamlToMap(InputStream yaml) {
        return YamlConfigSource.yamlToProperties((Map)new Yaml().load(yaml), "").collect(Collectors.toMap(Property::getName, Property::getValue));
    }

    private static Stream<Property> yamlToProperties(Map<String, Object> map, String prefix) {
        return map.entrySet().stream().flatMap(e -> {
            if (e.getValue() instanceof Map) {
                return YamlConfigSource.yamlToProperties((Map)e.getValue(), prefix + ((String)e.getKey()).toLowerCase() + ".");
            }
            return Stream.of(new Property(prefix + ((String)e.getKey()).toLowerCase(), e.getValue().toString()));
        });
    }

    private static class Property {
        private final String name;
        private final String value;

        private Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

