/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public abstract class SourceVisitor<R> {
    private final String name;
    private final String[] tagKeyValues;
    private static final boolean IS_DEBUGGING = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private boolean cursored = IS_DEBUGGING;
    private final ThreadLocal<List<SourceVisitor<R>>> andThen = new ThreadLocal();
    private final ThreadLocal<Cursor> cursor = new ThreadLocal();
    protected volatile int cycle = 0;

    public SourceVisitor(String name, String ... tagKeyValues) {
        this.name = name;
        this.tagKeyValues = tagKeyValues;
        this.andThen.set(new ArrayList());
    }

    protected void setCursoringOn() {
        this.cursored = true;
    }

    public List<SourceVisitor<R>> andThen() {
        return this.andThen.get();
    }

    public void andThen(SourceVisitor<R> visitor) {
        this.andThen.get().add(visitor);
    }

    public boolean isIdempotent() {
        return true;
    }

    public Cursor getCursor() {
        if (this.cursor.get() == null) {
            throw new IllegalStateException("Cursoring is not enabled for this visitor. Call setCursoredOn() in the visitor's constructor to enable.");
        }
        return this.cursor.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextCycle() {
        SourceVisitor sourceVisitor = this;
        synchronized (sourceVisitor) {
            ++this.cycle;
            if (this.andThen.get() != null) {
                this.andThen.get().clear();
            } else {
                this.andThen.set(new ArrayList());
            }
        }
    }

    public abstract R defaultTo(@Nullable Tree var1);

    public R reduce(R r1, R r2) {
        if (r1 instanceof Boolean) {
            return (R)Boolean.valueOf((Boolean)r1 != false || (Boolean)r2 != false);
        }
        if (r1 instanceof Set) {
            return (R)Stream.concat(StreamSupport.stream(((Iterable)r1).spliterator(), false), StreamSupport.stream(((Iterable)r2).spliterator(), false)).collect(Collectors.toSet());
        }
        if (r1 instanceof Collection) {
            return (R)Stream.concat(StreamSupport.stream(((Iterable)r1).spliterator(), false), StreamSupport.stream(((Iterable)r2).spliterator(), false)).collect(Collectors.toList());
        }
        return r1 == null ? r2 : r1;
    }

    public final R visit(@Nullable Tree tree) {
        if (tree == null) {
            return this.defaultTo(null);
        }
        if (this.cursored) {
            this.cursor.set(new Cursor(this.cursor.get(), tree));
        }
        Object t = this.reduce(tree.accept(this), this.visitTree(tree));
        if (this.cursored) {
            this.cursor.set(this.cursor.get().getParent());
        }
        return t;
    }

    public R visit(@Nullable List<? extends Tree> trees) {
        R r = this.defaultTo(null);
        if (trees != null) {
            for (Tree tree : trees) {
                if (tree == null) continue;
                r = this.reduce(r, this.visit(tree));
            }
        }
        return r;
    }

    public R visitTree(Tree tree) {
        return this.defaultTo(tree);
    }

    public final R visitAfter(R r, @Nullable Tree tree) {
        return tree == null ? r : this.reduce(r, this.visit(tree));
    }

    public final R visitAfter(R r, @Nullable List<? extends Tree> trees) {
        return this.reduce(r, this.visit(trees));
    }

    String getName() {
        return this.name;
    }

    String[] getTagKeyValues() {
        return this.tagKeyValues;
    }
}

