/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.refactor;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.Tree;
import org.openrewrite.refactor.FindIndentVisitor;

public class Formatter {
    private final Tree root;
    private Result wholeSourceIndent;

    public Formatter(Tree root) {
        this.root = root;
    }

    protected Result wholeSourceIndent() {
        if (this.wholeSourceIndent == null) {
            FindIndentVisitor wholeSourceIndentVisitor = new FindIndentVisitor(0);
            wholeSourceIndentVisitor.visit(this.root);
            this.wholeSourceIndent = new Result(0, wholeSourceIndentVisitor.getMostCommonIndent() > 0 ? wholeSourceIndentVisitor.getMostCommonIndent() : 4, wholeSourceIndentVisitor.isIndentedWithSpaces());
        }
        return this.wholeSourceIndent;
    }

    public Result findIndent(int enclosingIndent, Tree ... trees) {
        FindIndentVisitor findIndentVisitor = new FindIndentVisitor(enclosingIndent);
        for (Tree tree : trees) {
            findIndentVisitor.visit(tree);
        }
        int indentToUse = findIndentVisitor.getMostCommonIndent() > 0 ? findIndentVisitor.getMostCommonIndent() : this.wholeSourceIndent().getIndentToUse();
        boolean indentedWithSpaces = findIndentVisitor.getTotalLines() > 0 ? findIndentVisitor.isIndentedWithSpaces() : this.wholeSourceIndent().isIndentedWithSpaces();
        return new Result(enclosingIndent, indentToUse, indentedWithSpaces);
    }

    public static class Result {
        private final int enclosingIndent;
        private final int indentToUse;
        private final boolean indentedWithSpaces;

        public String getPrefix() {
            return this.getPrefix(0);
        }

        public String getPrefix(int offset) {
            return IntStream.range(0, this.indentToUse + this.indentToUse * offset + this.enclosingIndent).mapToObj(i -> this.indentedWithSpaces ? " " : "\t").collect(Collectors.joining("", "\n", ""));
        }

        public Result(int enclosingIndent, int indentToUse, boolean indentedWithSpaces) {
            this.enclosingIndent = enclosingIndent;
            this.indentToUse = indentToUse;
            this.indentedWithSpaces = indentedWithSpaces;
        }

        public int getEnclosingIndent() {
            return this.enclosingIndent;
        }

        public int getIndentToUse() {
            return this.indentToUse;
        }

        public boolean isIndentedWithSpaces() {
            return this.indentedWithSpaces;
        }
    }
}

