/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.config.CompositeSourceVisitor;
import org.openrewrite.config.ProfileConfiguration;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.openrewrite.config.SourceVisitorLoader;
import org.yaml.snakeyaml.Yaml;

public class YamlResourceLoader
implements ProfileConfigurationLoader,
SourceVisitorLoader {
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Map<String, ProfileConfiguration> profiles = new HashMap<String, ProfileConfiguration>();
    private final Collection<SourceVisitor<?>> visitors = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlResourceLoader(InputStream yamlInput) throws UncheckedIOException {
        try {
            Yaml yaml = new Yaml();
            for (Object resource : yaml.loadAll(yamlInput)) {
                String type;
                if (!(resource instanceof Map)) continue;
                Map resourceMap = (Map)resource;
                switch (type = resourceMap.getOrDefault("type", "invalid").toString()) {
                    case "beta.openrewrite.org/v1/visitor": {
                        this.mapVisitor(resourceMap);
                        break;
                    }
                    case "beta.openrewrite.org/v1/profile": {
                        this.mapProfile(resourceMap);
                    }
                }
            }
        }
        finally {
            try {
                yamlInput.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void mapVisitor(Map<String, Object> visitorMap) {
        Validated validation = Validated.required("name", visitorMap.get("name")).and(Validated.required("visitors", visitorMap.get("visitors"))).and(Validated.test("visitors", "must be a list", visitorMap.get("visitors"), visitors -> visitors instanceof List));
        if (validation.isInvalid()) {
            throw new ValidationException(validation);
        }
        ArrayList<SourceVisitor<Object>> subVisitors = new ArrayList<SourceVisitor<Object>>();
        for (Object subVisitorNameAndConfig : (List)visitorMap.get("visitors")) {
            try {
                if (subVisitorNameAndConfig instanceof String) {
                    subVisitors.add((SourceVisitor)this.visitorClass((String)subVisitorNameAndConfig).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                if (!(subVisitorNameAndConfig instanceof Map)) continue;
                for (Map.Entry subVisitorEntry : ((Map)subVisitorNameAndConfig).entrySet()) {
                    SourceVisitor subVisitor = (SourceVisitor)this.visitorClass((String)subVisitorEntry.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    propertyConverter.updateValue((Object)subVisitor, subVisitorEntry.getValue());
                    subVisitors.add(subVisitor);
                }
            }
            catch (Exception e) {
                throw new ValidationException(Validated.invalid("visitor", subVisitorNameAndConfig, "must be constructable", e));
            }
        }
        this.visitors.add(new CompositeSourceVisitor(visitorMap.get("name").toString(), subVisitors));
    }

    private Class<?> visitorClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ignored) {
            return Class.forName("org.openrewrite." + name);
        }
    }

    private void mapProfile(Map<String, Object> profileMap) {
        ProfileConfiguration profile = new ProfileConfiguration();
        try {
            propertyConverter.updateValue((Object)profile, profileMap);
        }
        catch (JsonMappingException e) {
            throw new ValidationException(Validated.invalid("profile", profileMap, "must be a valid profile configuration", e));
        }
        this.profiles.compute(profile.getName(), (name, existing) -> profile.merge((ProfileConfiguration)existing));
    }

    @Override
    public Collection<ProfileConfiguration> loadProfiles() {
        return this.profiles.values();
    }

    @Override
    public Collection<SourceVisitor<?>> loadVisitors() {
        return this.visitors;
    }
}

