/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public interface RefactorVisitorSupport {
    default public <T extends Tree> T refactor(T t, Function<T, Tree> callSuper) {
        return (T)callSuper.apply(t);
    }

    default public <T extends Tree> T refactor(@Nullable Tree tree) {
        return (T)this.visit(tree);
    }

    default public <T extends Tree> List<T> refactor(@Nullable List<T> trees) {
        if (trees == null) {
            return null;
        }
        ArrayList<T> mutatedTrees = new ArrayList<T>(trees.size());
        boolean changed = false;
        for (Tree tree : trees) {
            T mutated = this.refactor(tree);
            if (mutated != tree) {
                changed = true;
            }
            mutatedTrees.add(mutated);
        }
        return changed ? mutatedTrees : trees;
    }

    public Tree visit(@Nullable Tree var1);
}

