/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.openrewrite.gradle.RecipeDependenciesDownloadTask;
import org.openrewrite.gradle.RecipeDependenciesExtension;
import org.openrewrite.gradle.RecipeDependenciesTypeTableTask;
import org.openrewrite.gradle.RewriteJavaPlugin;
import org.openrewrite.gradle.RewriteRecipeLibraryExtension;

public class RewriteRecipeLibraryBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        RewriteRecipeLibraryExtension ext = (RewriteRecipeLibraryExtension)project.getExtensions().create("rewriteRecipe", RewriteRecipeLibraryExtension.class, new Object[0]);
        ext.getRewriteVersion().convention((Object)(project.hasProperty("releasing") ? "latest.release" : "latest.integration"));
        project.getPlugins().apply(RewriteJavaPlugin.class);
        project.getExtensions().create("recipeDependencies", RecipeDependenciesExtension.class, new Object[0]);
        project.getTasks().register("createTypeTable", RecipeDependenciesTypeTableTask.class, task -> task.getSourceSetName().convention((Object)"main"));
        project.getTasks().register("downloadRecipeDependencies", RecipeDependenciesDownloadTask.class);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            JavaPluginExtension javaExt = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            javaExt.getSourceSets().all(sourceSet -> {
                String taskName;
                String sourceSetName = sourceSet.getName();
                String string = taskName = "main".equals(sourceSetName) ? "createTypeTable" : "create" + RewriteRecipeLibraryBasePlugin.capitalize(sourceSetName) + "TypeTable";
                if (!"main".equals(sourceSetName)) {
                    project.getTasks().register(taskName, RecipeDependenciesTypeTableTask.class, task -> {
                        task.getSourceSetName().convention((Object)sourceSetName);
                        task.getTargetDir().convention(project.getLayout().getProjectDirectory().dir("src/" + sourceSetName + "/resources"));
                    });
                }
            });
        });
    }

    private static String capitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

